/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file;

import com.ionic.sdk.agent.cipher.file.FileCipherAbstract;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesDefault;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.csv.input.CsvInput;
import com.ionic.sdk.agent.cipher.file.family.csv.output.CsvOutput;
import com.ionic.sdk.agent.cipher.file.family.csv.sig.CsvSignerBytes;
import com.ionic.sdk.agent.cipher.file.family.csv.sig.CsvSignerFile;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public final class CsvFileCipher
extends FileCipherAbstract {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String FAMILY = "csv";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_LATEST = "1.0";
    private static final List<String> SUPPORTED_VERSIONS = Collections.singletonList("1.0");

    public CsvFileCipher(KeyServices agent) {
        super(agent, new FileCryptoCoverPageServicesDefault());
    }

    public CsvFileCipher(KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        super(agent, coverPageServices);
    }

    @Override
    @Deprecated
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public String getFamilyString() {
        return FAMILY;
    }

    @Override
    public CipherFamily getCipherFamily() {
        return CipherFamily.FAMILY_CSV;
    }

    @Override
    public List<String> getVersions() {
        return new ArrayList<String>(SUPPORTED_VERSIONS);
    }

    @Override
    public String getDefaultVersion() {
        return "1.0";
    }

    @Override
    public boolean isVersionSupported(String version) {
        return SUPPORTED_VERSIONS.contains(version);
    }

    @Override
    public FileCryptoFileInfo getFileInfo(String filePath) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        File file = new File(filePath);
        long length = file.length();
        if (file.exists() && file.length() > 0L) {
            try (FileInputStream is = new FileInputStream(file);){
                CsvInput csvInput = new CsvInput(is, length, this.getServices());
                FileCryptoDecryptAttributes decryptAttributes = new FileCryptoDecryptAttributes();
                try {
                    csvInput.init(fileInfo, decryptAttributes);
                    csvInput.read();
                }
                catch (IonicException e) {
                    this.logger.fine(e.getMessage());
                }
            }
            catch (IOException e) {
                throw new IonicException(80008, (Throwable)e);
            }
        }
        return fileInfo;
    }

    @Override
    public FileCryptoFileInfo getFileInfo(byte[] text) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        if (text.length > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(text);
            CsvInput csvInput = new CsvInput(inputStream, text.length, null);
            FileCryptoDecryptAttributes decryptAttributes = new FileCryptoDecryptAttributes();
            try {
                csvInput.init(fileInfo, decryptAttributes);
                csvInput.read();
            }
            catch (IonicException e) {
                this.logger.fine(e.getMessage());
            }
            catch (IOException e) {
                throw new IonicException(80009);
            }
        }
        return fileInfo;
    }

    @Override
    protected byte[] encryptInternal(byte[] plainText, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(plainText != null, 80006, byte[].class.getName());
        SdkData.checkTrue(plainText.length > 0, 80009);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(plainText));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        CsvOutput ionicOutput = this.encryptInternal(is, plainText.length, dos, attributes);
        byte[] bytes = bos.toByteArray();
        byte[] signature = ionicOutput.getSignatureWrapped();
        if (signature != null) {
            CsvSignerBytes signer = new CsvSignerBytes(bytes);
            signer.apply(signature, ionicOutput.getHeaderLengthCsv(), ionicOutput.getHeaderLengthWrapped());
        }
        return bytes;
    }

    @Override
    protected byte[] decryptInternal(byte[] cipherText, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(cipherText != null, 80006);
        SdkData.checkTrue(cipherText.length > 0, 80006);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        ByteArrayInputStream is = new ByteArrayInputStream(cipherText);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        this.decryptInternal(is, cipherText.length, os, attributes);
        return bos.toByteArray();
    }

    @Override
    protected void encryptInternal(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        String version = attributes.getVersion();
        boolean versionOK = SUPPORTED_VERSIONS.contains(version) || Value.isEmpty(version);
        SdkData.checkTrue(versionOK, 80012);
        try {
            this.encryptInternal2(sourceFile, targetFile, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptInternal2(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException, IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            this.encryptInternal3(is, sourceFile.length(), targetFile, attributes);
        }
    }

    private void encryptInternal3(InputStream is, long sizeInput, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(targetFile, "rwd");
        try (FileOutputStream fos = new FileOutputStream(randomAccessFile.getFD());){
            DataOutputStream dos = new DataOutputStream(fos);
            CsvOutput ionicOutput = this.encryptInternal(is, sizeInput, dos, attributes);
            byte[] signature = ionicOutput.getSignatureWrapped();
            if (signature != null) {
                CsvSignerFile signer = new CsvSignerFile(randomAccessFile.getChannel());
                signer.apply(signature, ionicOutput.getHeaderLengthCsv(), ionicOutput.getHeaderLengthWrapped());
            }
            dos.close();
        }
    }

    @Override
    protected void decryptInternal(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        try {
            this.decryptInternal2(sourceFile, targetFile, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decryptInternal2(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException, IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            this.decryptInternal3(is, sourceFile.length(), targetFile, attributes);
        }
    }

    private void decryptInternal3(InputStream is, long sizeInput, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            this.decryptInternal(is, sizeInput, os, attributes);
        }
    }

    private CsvOutput encryptInternal(InputStream plainText, long sizeInput, DataOutputStream cipherText, FileCryptoEncryptAttributes encryptAttributes) throws IonicException {
        try {
            ReadableByteChannel plainChannel = Channels.newChannel(plainText);
            CsvOutput ionicOutput = new CsvOutput(cipherText, sizeInput, this.getServices(), this.getCoverPageServices());
            ionicOutput.init(encryptAttributes);
            ByteBuffer bufferPlainText = ionicOutput.getPlainText();
            while (plainText.available() > 0) {
                bufferPlainText.clear();
                plainChannel.read(bufferPlainText);
                bufferPlainText.limit(bufferPlainText.position());
                bufferPlainText.position(0);
                ionicOutput.write(bufferPlainText);
            }
            ionicOutput.doFinal();
            cipherText.flush();
            return ionicOutput;
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }

    private void decryptInternal(InputStream cipherText, long sizeInput, OutputStream plainText, FileCryptoDecryptAttributes attributes) throws IonicException {
        try {
            WritableByteChannel plainChannel = Channels.newChannel(plainText);
            CsvInput ionicInput = new CsvInput(cipherText, sizeInput, this.getServices());
            FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
            ionicInput.init(fileInfo, attributes);
            while (ionicInput.available() > 0) {
                plainChannel.write(ionicInput.read());
            }
            ionicInput.doFinal();
            plainText.flush();
        }
        catch (IonicException e) {
            this.handleFileCryptoException(e, FileType.FILETYPE_CSV, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }
}

