/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file;

import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesDefault;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCipherUtils;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.File;
import java.util.List;

public abstract class FileCipherAbstract {
    private KeyServices agent;
    private FileCryptoCoverPageServicesInterface coverPageServices;

    public FileCipherAbstract(KeyServices agent) {
        this(agent, new FileCryptoCoverPageServicesDefault());
    }

    public FileCipherAbstract(KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        this.agent = agent;
        this.coverPageServices = coverPageServices;
    }

    public KeyServices getServices() {
        return this.agent;
    }

    public FileCryptoCoverPageServicesInterface getCoverPageServices() {
        return this.coverPageServices;
    }

    @Deprecated
    public abstract String getFamily();

    public abstract String getFamilyString();

    public abstract CipherFamily getCipherFamily();

    public abstract List<String> getVersions();

    public abstract String getDefaultVersion();

    public abstract boolean isVersionSupported(String var1);

    public abstract FileCryptoFileInfo getFileInfo(String var1) throws IonicException;

    public abstract FileCryptoFileInfo getFileInfo(byte[] var1) throws IonicException;

    public byte[] encrypt(byte[] plainText, FileCryptoEncryptAttributes attributes) throws IonicException {
        return this.encryptInternal(plainText, attributes);
    }

    public byte[] encrypt(byte[] plainText) throws IonicException {
        return this.encryptInternal(plainText, new FileCryptoEncryptAttributes());
    }

    public void encrypt(String sourcePath, String targetPath, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(sourcePath != null, 80006, File.class.getName());
        SdkData.checkTrue(targetPath != null, 80006, File.class.getName());
        this.encryptInternal(new File(sourcePath), new File(targetPath), attributes);
    }

    public void encrypt(String sourcePath, String targetPath) throws IonicException {
        SdkData.checkTrue(sourcePath != null, 80006, File.class.getName());
        SdkData.checkTrue(targetPath != null, 80006, File.class.getName());
        this.encryptInternal(new File(sourcePath), new File(targetPath), new FileCryptoEncryptAttributes());
    }

    public void encrypt(String filePath, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(filePath != null, 80006, File.class.getName());
        File originalFile = new File(filePath);
        File tempFile = FileCipherUtils.generateTempFile(originalFile);
        this.encryptInternal(originalFile, tempFile, attributes);
        FileCipherUtils.renameFile(tempFile, originalFile);
    }

    public void encrypt(String filePath) throws IonicException {
        SdkData.checkTrue(filePath != null, 80006, File.class.getName());
        File originalFile = new File(filePath);
        File tempFile = FileCipherUtils.generateTempFile(originalFile);
        this.encryptInternal(originalFile, tempFile, new FileCryptoEncryptAttributes());
        FileCipherUtils.renameFile(tempFile, originalFile);
    }

    public byte[] decrypt(byte[] cipherText, FileCryptoDecryptAttributes attributes) throws IonicException {
        return this.decryptInternal(cipherText, attributes);
    }

    public byte[] decrypt(byte[] cipherText) throws IonicException {
        return this.decryptInternal(cipherText, new FileCryptoDecryptAttributes());
    }

    public void decrypt(String sourcePath, String targetPath, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(sourcePath != null, 80006, File.class.getName());
        SdkData.checkTrue(targetPath != null, 80006, File.class.getName());
        this.decryptInternal(new File(sourcePath), new File(targetPath), attributes);
    }

    public void decrypt(String sourcePath, String targetPath) throws IonicException {
        SdkData.checkTrue(sourcePath != null, 80006, File.class.getName());
        SdkData.checkTrue(targetPath != null, 80006, File.class.getName());
        this.decryptInternal(new File(sourcePath), new File(targetPath), new FileCryptoDecryptAttributes());
    }

    public void decrypt(String filePath, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(filePath != null, 80006, File.class.getName());
        File originalFile = new File(filePath);
        File tempFile = FileCipherUtils.generateTempFile(originalFile);
        this.decryptInternal(originalFile, tempFile, attributes);
        FileCipherUtils.renameFile(tempFile, originalFile);
    }

    public void decrypt(String filePath) throws IonicException {
        SdkData.checkTrue(filePath != null, 80006, File.class.getName());
        File originalFile = new File(filePath);
        File tempFile = FileCipherUtils.generateTempFile(originalFile);
        this.decryptInternal(originalFile, tempFile, new FileCryptoDecryptAttributes());
        FileCipherUtils.renameFile(tempFile, originalFile);
    }

    protected abstract byte[] encryptInternal(byte[] var1, FileCryptoEncryptAttributes var2) throws IonicException;

    protected abstract byte[] decryptInternal(byte[] var1, FileCryptoDecryptAttributes var2) throws IonicException;

    protected abstract void encryptInternal(File var1, File var2, FileCryptoEncryptAttributes var3) throws IonicException;

    protected abstract void decryptInternal(File var1, File var2, FileCryptoDecryptAttributes var3) throws IonicException;

    protected final void handleFileCryptoException(IonicException e, FileType fileType, FileCryptoDecryptAttributes decryptAttributes) throws IonicException {
        boolean isAcccessDenied = 40024 == e.getReturnCode();
        boolean shouldProvidePage = decryptAttributes.shouldProvideAccessDeniedPage();
        if (isAcccessDenied && shouldProvidePage) {
            decryptAttributes.setAccessDeniedPageOut(this.coverPageServices.getAccessDeniedPage(fileType));
        }
        throw e;
    }
}

