/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file;

import com.ionic.sdk.agent.cipher.file.FileCipherAbstract;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesDefault;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericInput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericOutput;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public final class GenericFileCipher
extends FileCipherAbstract {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String FAMILY = "generic";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_DEFAULT = "1.3";
    public static final String VERSION_LATEST = "1.3";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.1", "1.2", "1.3");

    public GenericFileCipher(KeyServices agent) {
        super(agent, new FileCryptoCoverPageServicesDefault());
    }

    public GenericFileCipher(KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        super(agent, coverPageServices);
    }

    @Override
    @Deprecated
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public String getFamilyString() {
        return FAMILY;
    }

    @Override
    public CipherFamily getCipherFamily() {
        return CipherFamily.FAMILY_GENERIC;
    }

    @Override
    public List<String> getVersions() {
        return new ArrayList<String>(SUPPORTED_VERSIONS);
    }

    @Override
    public String getDefaultVersion() {
        return "1.3";
    }

    @Override
    public boolean isVersionSupported(String version) {
        return SUPPORTED_VERSIONS.contains(version);
    }

    @Override
    public FileCryptoFileInfo getFileInfo(String filePath) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        File file = new File(filePath);
        long length = file.length();
        if (file.exists() && length > 0L) {
            try (FileInputStream is = new FileInputStream(file);){
                GenericInput genericInput = new GenericInput(is, length, this.getServices());
                FileCryptoDecryptAttributes decryptAttributes = new FileCryptoDecryptAttributes();
                try {
                    genericInput.init(fileInfo, decryptAttributes);
                }
                catch (IonicException e) {
                    this.logger.fine(e.getMessage());
                }
            }
            catch (IOException e) {
                throw new IonicException(80008, (Throwable)e);
            }
        }
        return fileInfo;
    }

    @Override
    public FileCryptoFileInfo getFileInfo(byte[] text) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        if (text.length > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(text);
            GenericInput genericInput = new GenericInput(inputStream, text.length, null);
            FileCryptoDecryptAttributes decryptAttributes = new FileCryptoDecryptAttributes();
            try {
                genericInput.init(fileInfo, decryptAttributes);
            }
            catch (IonicException e) {
                this.logger.fine(e.getMessage());
            }
        }
        return fileInfo;
    }

    @Override
    protected byte[] encryptInternal(byte[] plainText, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(plainText != null, 80006, byte[].class.getName());
        SdkData.checkTrue(plainText.length > 0, 80009);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(plainText));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        GenericOutput ionicOutput = this.encryptInternal(is, plainText.length, os, attributes);
        byte[] bytes = bos.toByteArray();
        byte[] signature = ionicOutput.getSignature();
        if (signature != null) {
            System.arraycopy(signature, 0, bytes, ionicOutput.getHeaderLength(), signature.length);
        }
        return bytes;
    }

    @Override
    protected byte[] decryptInternal(byte[] cipherText, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(cipherText != null, 80006);
        SdkData.checkTrue(cipherText.length > 0, 80006);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        ByteArrayInputStream is = new ByteArrayInputStream(cipherText);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        this.decryptInternal(is, cipherText.length, os, attributes);
        return bos.toByteArray();
    }

    @Override
    protected void encryptInternal(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        String version = attributes.getVersion();
        boolean versionOK = SUPPORTED_VERSIONS.contains(version) || Value.isEmpty(version);
        SdkData.checkTrue(versionOK, 80012);
        try {
            this.encryptInternal2(sourceFile, targetFile, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptInternal2(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException, IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            this.encryptInternal3(is, sourceFile.length(), targetFile, attributes);
        }
    }

    private void encryptInternal3(InputStream is, long sizeInput, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            BufferedOutputStream os = new BufferedOutputStream(fos);
            GenericOutput ionicOutput = this.encryptInternal(is, sizeInput, os, attributes);
            byte[] signature = ionicOutput.getSignature();
            if (signature != null) {
                fos.getChannel().position(ionicOutput.getHeaderLength());
                fos.write(signature);
            }
            os.close();
        }
    }

    @Override
    protected void decryptInternal(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        try {
            this.decryptInternal2(sourceFile, targetFile, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decryptInternal2(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException, IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            this.decryptInternal3(is, sourceFile.length(), targetFile, attributes);
        }
    }

    private void decryptInternal3(InputStream is, long sizeInput, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            this.decryptInternal(is, sizeInput, os, attributes);
        }
    }

    private GenericOutput encryptInternal(InputStream plainText, long sizeInput, OutputStream cipherText, FileCryptoEncryptAttributes attributes) throws IonicException {
        try {
            ReadableByteChannel plainChannel = Channels.newChannel(plainText);
            GenericOutput ionicOutput = new GenericOutput(cipherText, sizeInput, this.getServices());
            ionicOutput.init(attributes);
            ByteBuffer bufferPlainText = ionicOutput.getPlainText();
            while (plainText.available() > 0) {
                bufferPlainText.clear();
                plainChannel.read(bufferPlainText);
                bufferPlainText.limit(bufferPlainText.position());
                bufferPlainText.position(0);
                ionicOutput.write(bufferPlainText);
            }
            ionicOutput.doFinal();
            return ionicOutput;
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }

    private void decryptInternal(InputStream cipherText, long sizeInput, OutputStream plainText, FileCryptoDecryptAttributes decryptAttributes) throws IonicException {
        try {
            WritableByteChannel plainChannel = Channels.newChannel(plainText);
            GenericInput ionicInput = new GenericInput(cipherText, sizeInput, this.getServices());
            FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
            ionicInput.init(fileInfo, decryptAttributes);
            while (ionicInput.available() > 0) {
                plainChannel.write(ionicInput.read());
            }
            ionicInput.doFinal();
            plainText.flush();
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }
}

