/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file;

import com.ionic.sdk.agent.cipher.file.FileCipherAbstract;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesDefault;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCipherUtils;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.openxml.OpenXmlUtils;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXmlInput;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXmlPortionMarkInput;
import com.ionic.sdk.agent.cipher.file.family.openxml.output.OpenXmlOutput;
import com.ionic.sdk.core.datastructures.Tuple;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public final class OpenXmlFileCipher
extends FileCipherAbstract {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String FAMILY = "openxml";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_DEFAULT = "1.1";
    public static final String VERSION_LATEST = "1.1";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.0", "1.1");

    public OpenXmlFileCipher(KeyServices agent) {
        super(agent, new FileCryptoCoverPageServicesDefault());
    }

    public OpenXmlFileCipher(KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        super(agent, coverPageServices);
    }

    @Override
    @Deprecated
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public String getFamilyString() {
        return FAMILY;
    }

    @Override
    public CipherFamily getCipherFamily() {
        return CipherFamily.FAMILY_OPENXML;
    }

    @Override
    public List<String> getVersions() {
        return new ArrayList<String>(SUPPORTED_VERSIONS);
    }

    @Override
    public String getDefaultVersion() {
        return "1.1";
    }

    @Override
    public boolean isVersionSupported(String version) {
        return SUPPORTED_VERSIONS.contains(version);
    }

    @Override
    public FileCryptoFileInfo getFileInfo(String filePath) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        File file = new File(filePath);
        if (file.exists() && file.length() > 0L) {
            try (FileInputStream is = new FileInputStream(file);){
                try {
                    OpenXmlInput.getFileInfo(is, fileInfo);
                }
                catch (IonicException e) {
                    this.logger.fine(e.getMessage());
                }
            }
            catch (IOException e) {
                throw new IonicException(80008, (Throwable)e);
            }
        }
        return fileInfo;
    }

    @Override
    public FileCryptoFileInfo getFileInfo(byte[] text) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        if (text.length > 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(text);
            try {
                OpenXmlInput.getFileInfo(inputStream, fileInfo);
            }
            catch (IonicException e) {
                this.logger.fine(e.getMessage());
            }
        }
        return fileInfo;
    }

    @Override
    protected byte[] encryptInternal(byte[] plainText, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(plainText != null, 80006, byte[].class.getName());
        SdkData.checkTrue(plainText.length > 0, 80009);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        ByteArrayInputStream is = new ByteArrayInputStream(plainText);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean isVersion10 = VERSION_1_0.equals(attributes.getVersion());
        FileType fileType = FileType.FILETYPE_UNKNOWN;
        byte[] customPropFile = null;
        if (!isVersion10) {
            Tuple<FileType, byte[]> typeAndProps = OpenXmlUtils.doFirstPassThrough(is, attributes.getShouldCopyCustomProps());
            fileType = typeAndProps.first();
            customPropFile = typeAndProps.second();
            is.reset();
        }
        this.encryptInternal((InputStream)is, bos, attributes, fileType, customPropFile, null);
        return bos.toByteArray();
    }

    @Override
    protected byte[] decryptInternal(byte[] cipherText, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(cipherText != null, 80006);
        SdkData.checkTrue(cipherText.length > 0, 80007);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        ByteArrayInputStream is = new ByteArrayInputStream(cipherText);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        this.decryptInternal(is, os, attributes);
        byte[] decryptOutput = bos.toByteArray();
        OpenXmlPortionMarkInput portionMark = new OpenXmlPortionMarkInput(this.getServices(), attributes);
        is = new ByteArrayInputStream(decryptOutput);
        if (portionMark.findPortionMarkedSections(is)) {
            bos = new ByteArrayOutputStream();
            os = new BufferedOutputStream(bos);
            is.reset();
            portionMark.decryptPortionMarkedSections(is, os);
            decryptOutput = bos.toByteArray();
        }
        return decryptOutput;
    }

    @Override
    protected void encryptInternal(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        String version = attributes.getVersion();
        boolean versionOK = SUPPORTED_VERSIONS.contains(version) || Value.isEmpty(version);
        SdkData.checkTrue(versionOK, 80012);
        boolean isVersion10 = VERSION_1_0.equals(attributes.getVersion());
        FileType fileType = FileType.FILETYPE_UNKNOWN;
        byte[] customPropFile = null;
        if (!isVersion10) {
            Tuple<FileType, byte[]> typeAndProps = OpenXmlUtils.doFirstPassThrough(sourceFile, attributes.getShouldCopyCustomProps());
            fileType = typeAndProps.first();
            customPropFile = typeAndProps.second();
        }
        File tempFile = FileCipherUtils.generateTempFile(sourceFile);
        try {
            this.encryptInternal(sourceFile, targetFile, attributes, fileType, customPropFile, tempFile);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
        try {
            Files.deleteIfExists(tempFile.toPath());
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptInternal(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes, FileType fileType, byte[] customPropFile, File tempFile) throws IonicException, IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            this.encryptInternal((InputStream)is, targetFile, attributes, fileType, customPropFile, tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptInternal(InputStream is, File targetFile, FileCryptoEncryptAttributes attributes, FileType fileType, byte[] customPropFile, File tempFile) throws IonicException, IOException {
        try (FileOutputStream os = new FileOutputStream(targetFile);){
            this.encryptInternal(is, os, attributes, fileType, customPropFile, tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decryptInternal(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException {
        block40: {
            SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
            SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
            SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
            SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
            SdkData.checkTrue(sourceFile.exists(), 80015);
            try {
                try (FileInputStream isSourceFile = new FileInputStream(sourceFile);
                     FileOutputStream osTargetFile = new FileOutputStream(targetFile);){
                    this.decryptInternal(isSourceFile, new BufferedOutputStream(osTargetFile), attributes);
                }
                OpenXmlPortionMarkInput portionMark = new OpenXmlPortionMarkInput(this.getServices(), attributes);
                boolean foundPortions = false;
                try (FileInputStream isTargetFile = new FileInputStream(targetFile);){
                    foundPortions = portionMark.findPortionMarkedSections(isTargetFile);
                }
                if (!foundPortions) break block40;
                boolean decrypted = false;
                File tempFile = FileCipherUtils.generateTempFile(targetFile);
                try (FileInputStream isTargetFile2 = new FileInputStream(targetFile);
                     BufferedOutputStream osTempFile = new BufferedOutputStream(new FileOutputStream(tempFile));){
                    decrypted = portionMark.decryptPortionMarkedSections(isTargetFile2, osTempFile);
                }
                if (decrypted) {
                    FileCipherUtils.renameFile(tempFile, targetFile);
                } else {
                    Files.delete(tempFile.toPath());
                }
            }
            catch (FileNotFoundException e) {
                throw new IonicException(80008, (Throwable)e);
            }
            catch (IOException e) {
                throw new IonicException(80023, (Throwable)e);
            }
        }
    }

    private OpenXmlOutput encryptInternal(InputStream plainText, OutputStream cipherText, FileCryptoEncryptAttributes encryptAttributes, FileType fileType, byte[] customPropFile, File tempFile) throws IonicException {
        try {
            OpenXmlOutput ionicOutput = new OpenXmlOutput(cipherText, this.getServices(), this.getCoverPageServices(), fileType, customPropFile, tempFile);
            ionicOutput.init(encryptAttributes);
            ionicOutput.doEncryption(plainText);
            cipherText.flush();
            return ionicOutput;
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }

    private void decryptInternal(InputStream cipherText, OutputStream plainText, FileCryptoDecryptAttributes attributes) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        try {
            WritableByteChannel plainChannel = Channels.newChannel(plainText);
            OpenXmlInput ionicInput = new OpenXmlInput(cipherText, this.getServices());
            ionicInput.init(fileInfo, attributes);
            while (ionicInput.available() > 0) {
                plainChannel.write(ionicInput.read());
            }
            ionicInput.doFinal();
            plainText.flush();
        }
        catch (IonicException e) {
            boolean isAcccessDenied = 40024 == e.getReturnCode();
            boolean shouldProvidePage = attributes.shouldProvideAccessDeniedPage();
            if (isAcccessDenied && shouldProvidePage && fileInfo.getCipherVersion().equals("1.1")) {
                FileType fileType = this.getDecryptingFileType(cipherText);
                attributes.setAccessDeniedPageOut(this.getCoverPageServices().getAccessDeniedPage(fileType));
            }
            throw e;
        }
        catch (IOException e) {
            throw new IonicException(80016, (Throwable)e);
        }
    }

    private FileType getDecryptingFileType(InputStream cipherText) {
        try {
            try {
                FileInputStream fs = (FileInputStream)cipherText;
                fs.getChannel().position(0L);
            }
            catch (ClassCastException e) {
                cipherText.reset();
            }
            Tuple<FileType, byte[]> fileTypeTuple = OpenXmlUtils.doFirstPassThrough(cipherText, false);
            return fileTypeTuple.first();
        }
        catch (IOException e) {
            return FileType.FILETYPE_UNKNOWN;
        }
        catch (IonicException e) {
            return FileType.FILETYPE_UNKNOWN;
        }
    }
}

