/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file;

import com.ionic.sdk.agent.cipher.file.FileCipherAbstract;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesDefault;
import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.pdf.input.PdfInput;
import com.ionic.sdk.agent.cipher.file.family.pdf.output.PdfOutput;
import com.ionic.sdk.core.io.SeekableByteBufferChannel;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public final class PdfFileCipher
extends FileCipherAbstract {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String FAMILY = "pdf";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_LATEST = "1.0";
    private static final List<String> SUPPORTED_VERSIONS = Collections.singletonList("1.0");

    public PdfFileCipher(KeyServices agent) {
        super(agent, new FileCryptoCoverPageServicesDefault());
    }

    public PdfFileCipher(KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        super(agent, coverPageServices);
    }

    @Override
    @Deprecated
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public String getFamilyString() {
        return FAMILY;
    }

    @Override
    public CipherFamily getCipherFamily() {
        return CipherFamily.FAMILY_PDF;
    }

    @Override
    public List<String> getVersions() {
        return new ArrayList<String>(SUPPORTED_VERSIONS);
    }

    @Override
    public String getDefaultVersion() {
        return "1.0";
    }

    @Override
    public boolean isVersionSupported(String version) {
        return SUPPORTED_VERSIONS.contains(version);
    }

    @Override
    public FileCryptoFileInfo getFileInfo(String filePath) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        File file = new File(filePath);
        if (file.exists() && file.length() > 0L) {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rwd");
                 FileChannel channel = raf.getChannel();){
                PdfInput ionicInput = new PdfInput(channel, this.getServices());
                FileCryptoDecryptAttributes decryptAttributes = new FileCryptoDecryptAttributes();
                try {
                    ionicInput.init(fileInfo, decryptAttributes);
                }
                catch (IonicException e) {
                    this.logger.fine(e.getMessage());
                }
            }
            catch (IOException e) {
                throw new IonicException(80008, (Throwable)e);
            }
        }
        return fileInfo;
    }

    @Override
    public FileCryptoFileInfo getFileInfo(byte[] text) throws IonicException {
        FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
        if (text.length > 0) {
            try (SeekableByteBufferChannel channel = new SeekableByteBufferChannel(text);){
                PdfInput ionicInput = new PdfInput(channel, this.getServices());
                FileCryptoDecryptAttributes decryptAttributes = new FileCryptoDecryptAttributes();
                ionicInput.init(fileInfo, decryptAttributes);
            }
            catch (IonicException e) {
                this.logger.fine(e.getMessage());
            }
            catch (IOException e) {
                throw new IonicException(80009);
            }
        }
        return fileInfo;
    }

    @Override
    protected byte[] encryptInternal(byte[] plainText, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(plainText != null, 80006, byte[].class.getName());
        SdkData.checkTrue(plainText.length > 0, 80009);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(plainText));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PdfOutput ionicOutput = this.encryptInternal(is, plainText.length, bos, attributes);
        byte[] cipherText = bos.toByteArray();
        byte[] payloadPrologue = ionicOutput.getIonicPayloadPrologue();
        System.arraycopy(payloadPrologue, 0, cipherText, ionicOutput.getOffsetPayloadIonic(), payloadPrologue.length);
        byte[] signature = ionicOutput.getSignature();
        if (signature != null) {
            System.arraycopy(signature, 0, cipherText, ionicOutput.getSignatureOffset(), signature.length);
        }
        return cipherText;
    }

    @Override
    protected byte[] decryptInternal(byte[] cipherText, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(cipherText != null, 80006);
        SdkData.checkTrue(cipherText.length > 0, 80006);
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(bos);
        try (SeekableByteBufferChannel channel = new SeekableByteBufferChannel(cipherText);){
            this.decryptInternal(channel, os, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
        return bos.toByteArray();
    }

    @Override
    protected void encryptInternal(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoEncryptAttributes.class.getName());
        String version = attributes.getVersion();
        boolean versionOK = SUPPORTED_VERSIONS.contains(version) || Value.isEmpty(version);
        SdkData.checkTrue(versionOK, 80012);
        try {
            this.encryptInternal2(sourceFile, targetFile, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptInternal2(File sourceFile, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException, IOException {
        try (FileInputStream is = new FileInputStream(sourceFile);){
            this.encryptInternal3(is, sourceFile.length(), targetFile, attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptInternal3(InputStream plainText, long sizeInput, File targetFile, FileCryptoEncryptAttributes attributes) throws IonicException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(targetFile, "rwd");
        try (FileOutputStream cipherText = new FileOutputStream(randomAccessFile.getFD());){
            PdfOutput ionicOutput = this.encryptInternal(plainText, sizeInput, cipherText, attributes);
            FileChannel channel = randomAccessFile.getChannel();
            channel.position(ionicOutput.getOffsetPayloadIonic());
            channel.write(ByteBuffer.wrap(ionicOutput.getIonicPayloadPrologue()));
            channel.position(ionicOutput.getSignatureOffset());
            channel.write(ByteBuffer.wrap(ionicOutput.getSignature()));
        }
    }

    @Override
    protected void decryptInternal(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException {
        SdkData.checkTrue(attributes != null, 80006, FileCryptoDecryptAttributes.class.getName());
        SdkData.checkTrue(attributes.getKeyId().isEmpty(), 80005);
        SdkData.checkTrue(attributes.getFamily() == CipherFamily.FAMILY_UNKNOWN, 80005);
        SdkData.checkTrue(attributes.getVersion().isEmpty(), 80005);
        try {
            this.decryptInternal2(sourceFile, targetFile, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80008, (Throwable)e);
        }
    }

    private void decryptInternal2(File sourceFile, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException, IOException {
        try (RandomAccessFile raf = new RandomAccessFile(sourceFile, "rwd");
             FileChannel channel = raf.getChannel();){
            this.decryptInternal3(channel, targetFile, attributes);
        }
    }

    private void decryptInternal3(SeekableByteChannel cipherText, File targetFile, FileCryptoDecryptAttributes attributes) throws IonicException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            this.decryptInternal(cipherText, os, attributes);
        }
    }

    private PdfOutput encryptInternal(InputStream plainText, long sizeInput, OutputStream cipherText, FileCryptoEncryptAttributes encryptAttributes) throws IonicException {
        try {
            ReadableByteChannel plainChannel = Channels.newChannel(plainText);
            PdfOutput ionicOutput = new PdfOutput(cipherText, sizeInput, this.getServices(), this.getCoverPageServices());
            ionicOutput.init(encryptAttributes);
            ByteBuffer bufferPlainText = ionicOutput.getPlainText();
            while (plainText.available() > 0) {
                bufferPlainText.clear();
                plainChannel.read(bufferPlainText);
                bufferPlainText.limit(bufferPlainText.position());
                bufferPlainText.position(0);
                ionicOutput.write(bufferPlainText);
            }
            ionicOutput.doFinal();
            cipherText.flush();
            return ionicOutput;
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }

    private void decryptInternal(SeekableByteChannel cipherText, OutputStream plainText, FileCryptoDecryptAttributes attributes) throws IonicException {
        try {
            WritableByteChannel plainChannel = Channels.newChannel(plainText);
            PdfInput ionicInput = new PdfInput(cipherText, this.getServices());
            FileCryptoFileInfo fileInfo = new FileCryptoFileInfo();
            ionicInput.init(fileInfo, attributes);
            while (ionicInput.available() > 0) {
                plainChannel.write(ionicInput.read());
            }
            ionicInput.doFinal();
            plainText.flush();
        }
        catch (IonicException e) {
            this.handleFileCryptoException(e, FileType.FILETYPE_PDF, attributes);
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }
}

