/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.cover;

import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.core.res.Resource;
import com.ionic.sdk.core.vm.EOL;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;

public final class FileCryptoCoverPageServicesDefault
extends FileCryptoCoverPageServicesInterface {
    private static final String CSV_HEADER_STRING = "com/ionic/sdk/agent/cipher/file/cover/csv.header.string.csv";
    private static final String CSV_ACCESS_DENIED_STRING = "com/ionic/sdk/agent/cipher/file/cover/csv.access.denied.string.csv";
    private static final String PDF_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/ionic_cover_page.pdf";
    private static final String PDF_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/ionic_access_denied_page.pdf";
    private static final String DOCX_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/coverpage.docx";
    private static final String DOCX_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/accessdenied.docx";
    private static final String DOCM_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/coverpage.docm";
    private static final String DOCM_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/accessdenied.docm";
    private static final String PPTX_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/coverpage.pptx";
    private static final String PPTX_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/accessdenied.pptx";
    private static final String PPTM_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/coverpage.pptm";
    private static final String PPTM_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/accessdenied.pptm";
    private static final String XLSX_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/coverpage.xlsx";
    private static final String XLSX_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/accessdenied.xlsx";
    private static final String XLSM_COVER_PAGE_FILE = "com/ionic/sdk/agent/cipher/file/cover/coverpage.xlsm";
    private static final String XLSM_ACCESS_DENIED_FILE = "com/ionic/sdk/agent/cipher/file/cover/accessdenied.xlsm";

    @Override
    public byte[] getCoverPage(FileType fileType) throws IonicException {
        switch (fileType) {
            case FILETYPE_CSV: {
                return EOL.normalizeToWindows(DeviceUtils.read(Resource.resolve(CSV_HEADER_STRING)));
            }
            case FILETYPE_PDF: {
                return DeviceUtils.read(Resource.resolve(PDF_COVER_PAGE_FILE));
            }
            case FILETYPE_DOCX: {
                return DeviceUtils.read(Resource.resolve(DOCX_COVER_PAGE_FILE));
            }
            case FILETYPE_DOCM: {
                return DeviceUtils.read(Resource.resolve(DOCM_COVER_PAGE_FILE));
            }
            case FILETYPE_PPTX: {
                return DeviceUtils.read(Resource.resolve(PPTX_COVER_PAGE_FILE));
            }
            case FILETYPE_PPTM: {
                return DeviceUtils.read(Resource.resolve(PPTM_COVER_PAGE_FILE));
            }
            case FILETYPE_XLSX: {
                return DeviceUtils.read(Resource.resolve(XLSX_COVER_PAGE_FILE));
            }
            case FILETYPE_XLSM: {
                return DeviceUtils.read(Resource.resolve(XLSM_COVER_PAGE_FILE));
            }
        }
        throw new IonicException(80022);
    }

    @Override
    public byte[] getAccessDeniedPage(FileType fileType) throws IonicException {
        switch (fileType) {
            case FILETYPE_CSV: {
                return EOL.normalizeToWindows(DeviceUtils.read(Resource.resolve(CSV_ACCESS_DENIED_STRING)));
            }
            case FILETYPE_PDF: {
                return DeviceUtils.read(Resource.resolve(PDF_ACCESS_DENIED_FILE));
            }
            case FILETYPE_DOCX: {
                return DeviceUtils.read(Resource.resolve(DOCX_ACCESS_DENIED_FILE));
            }
            case FILETYPE_DOCM: {
                return DeviceUtils.read(Resource.resolve(DOCM_ACCESS_DENIED_FILE));
            }
            case FILETYPE_PPTX: {
                return DeviceUtils.read(Resource.resolve(PPTX_ACCESS_DENIED_FILE));
            }
            case FILETYPE_PPTM: {
                return DeviceUtils.read(Resource.resolve(PPTM_ACCESS_DENIED_FILE));
            }
            case FILETYPE_XLSX: {
                return DeviceUtils.read(Resource.resolve(XLSX_ACCESS_DENIED_FILE));
            }
            case FILETYPE_XLSM: {
                return DeviceUtils.read(Resource.resolve(XLSM_ACCESS_DENIED_FILE));
            }
        }
        throw new IonicException(80022);
    }
}

