/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.data;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.io.FileSystem;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.error.IonicException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalUseOnly
public final class FileCipherUtils {
    private static final String FORMAT_TEMP_NAME = "%s.TMP-%d";

    private FileCipherUtils() {
    }

    public static File generateTempFile(File file) throws IonicException {
        return new File(file.getParentFile(), FileCipherUtils.generateTempFileName(file.getName()));
    }

    private static String generateTempFileName(String filename) throws IonicException {
        return String.format(FORMAT_TEMP_NAME, filename, new CryptoRng().randInt32(0, Integer.MAX_VALUE));
    }

    public static void renameFile(File sourceFile, File targetFile) throws IonicException {
        Logger logger = Logger.getLogger(FileSystem.class.getName());
        try {
            Files.move(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            try {
                Files.delete(sourceFile.toPath());
            }
            catch (IOException ee) {
                logger.log(Level.SEVERE, ee.getMessage(), ee);
                throw new IonicException(80020, (Throwable)ee);
            }
        }
    }
}

