/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.data;

import com.ionic.sdk.agent.cipher.file.CsvFileCipher;
import com.ionic.sdk.agent.cipher.file.FileCipherAbstract;
import com.ionic.sdk.agent.cipher.file.GenericFileCipher;
import com.ionic.sdk.agent.cipher.file.OpenXmlFileCipher;
import com.ionic.sdk.agent.cipher.file.PdfFileCipher;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.error.IonicException;
import java.io.File;
import java.util.logging.Logger;

public final class FileCrypto {
    private static final Logger LOGGER = Logger.getLogger(FileCrypto.class.getName());
    private static final String OPENXML_1_0_EXTENSION_DOCXS = ".docxs";
    private static final String OPENXML_1_0_EXTENSION_PPTXS = ".pptxs";
    private static final String OPENXML_1_0_EXTENSION_XLSXS = ".xlsxs";

    private FileCrypto() {
    }

    public static String getFamilyString(CipherFamily cipherFamily) {
        String familyString;
        switch (cipherFamily) {
            case FAMILY_GENERIC: {
                familyString = "generic";
                break;
            }
            case FAMILY_CSV: {
                familyString = "csv";
                break;
            }
            case FAMILY_PDF: {
                familyString = "pdf";
                break;
            }
            case FAMILY_OPENXML: {
                familyString = "openxml";
                break;
            }
            default: {
                familyString = "unknown";
            }
        }
        return familyString;
    }

    public static FileCryptoFileInfo getFileInfo(String filePath) throws IonicException {
        File file = new File(filePath);
        LOGGER.fine(String.format("file, name = %s", file.getName()));
        return FileCrypto.getFileInfoInternal(filePath);
    }

    public static FileCryptoFileInfo getFileInfo(byte[] inputBytes) throws IonicException {
        LOGGER.fine(String.format("byte array, length = %d", inputBytes.length));
        return FileCrypto.getFileInfoInternal(inputBytes);
    }

    private static FileCryptoFileInfo getFileInfoInternal(String filepath) throws IonicException {
        FileCipherAbstract fileCipher;
        FileCipherAbstract[] fileCiphers;
        GenericFileCipher genCipher = new GenericFileCipher(null);
        FileCryptoFileInfo fileInfo = null;
        if (filepath.endsWith(OPENXML_1_0_EXTENSION_DOCXS) || filepath.endsWith(OPENXML_1_0_EXTENSION_PPTXS) || filepath.endsWith(OPENXML_1_0_EXTENSION_XLSXS)) {
            fileInfo = genCipher.getFileInfo(filepath);
            if (!fileInfo.getCipherFamily().equals((Object)CipherFamily.FAMILY_UNKNOWN)) {
                fileInfo.setCipherFamily(CipherFamily.FAMILY_OPENXML);
                fileInfo.setCipherVersion("1.0");
            }
            return fileInfo;
        }
        FileCipherAbstract[] fileCipherAbstractArray = fileCiphers = new FileCipherAbstract[]{new CsvFileCipher(null), new PdfFileCipher(null), new OpenXmlFileCipher(null), genCipher};
        int n = fileCipherAbstractArray.length;
        for (int i = 0; i < n && (fileInfo = (fileCipher = fileCipherAbstractArray[i]).getFileInfo(filepath)).getCipherFamily().equals((Object)CipherFamily.FAMILY_UNKNOWN); ++i) {
        }
        return fileInfo;
    }

    private static FileCryptoFileInfo getFileInfoInternal(byte[] headerBytes) throws IonicException {
        FileCipherAbstract fileCipher;
        FileCipherAbstract[] fileCiphers = new FileCipherAbstract[]{new CsvFileCipher(null), new PdfFileCipher(null), new OpenXmlFileCipher(null), new GenericFileCipher(null)};
        FileCryptoFileInfo fileInfo = null;
        FileCipherAbstract[] fileCipherAbstractArray = fileCiphers;
        int n = fileCipherAbstractArray.length;
        for (int i = 0; i < n && (fileInfo = (fileCipher = fileCipherAbstractArray[i]).getFileInfo(headerBytes)).getCipherFamily().equals((Object)CipherFamily.FAMILY_UNKNOWN); ++i) {
        }
        return fileInfo;
    }

    public static CipherFamily toCipherFamily(String family) {
        CipherFamily cipherFamily = CipherFamily.FAMILY_UNKNOWN;
        if ("generic".equals(family)) {
            cipherFamily = CipherFamily.FAMILY_GENERIC;
        } else if ("csv".equals(family)) {
            cipherFamily = CipherFamily.FAMILY_CSV;
        } else if ("pdf".equals(family)) {
            cipherFamily = CipherFamily.FAMILY_PDF;
        } else if ("openxml".equals(family)) {
            cipherFamily = CipherFamily.FAMILY_OPENXML;
        }
        return cipherFamily;
    }
}

