/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.data;

import com.ionic.sdk.agent.cipher.data.EncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;

public final class FileCryptoEncryptAttributes
extends EncryptAttributes {
    private CipherFamily cipherFamily;
    private String version;
    private boolean bShouldCopyCustomProps;

    public FileCryptoEncryptAttributes() {
        this("", null, null);
    }

    public FileCryptoEncryptAttributes(String version) {
        this(version, null, null);
    }

    public FileCryptoEncryptAttributes(KeyAttributesMap keyAttributes) {
        this("", keyAttributes, null);
    }

    public FileCryptoEncryptAttributes(KeyAttributesMap keyAttributes, KeyAttributesMap mutableAttributes) {
        this("", keyAttributes, mutableAttributes);
    }

    public FileCryptoEncryptAttributes(String version, KeyAttributesMap keyAttributes) {
        this(version, keyAttributes, null);
    }

    public FileCryptoEncryptAttributes(String version, KeyAttributesMap keyAttributes, KeyAttributesMap mutableAttributes) {
        super.setKeyAttributes(keyAttributes);
        super.setMutableKeyAttributes(mutableAttributes);
        this.cipherFamily = CipherFamily.FAMILY_UNKNOWN;
        this.version = version;
        this.bShouldCopyCustomProps = true;
    }

    public FileCryptoEncryptAttributes(FileCryptoEncryptAttributes encryptAttributes) {
        this(encryptAttributes.getVersion(), encryptAttributes.getKeyAttributes(), encryptAttributes.getMutableKeyAttributes());
        super.setMetadata(encryptAttributes.getMetadata());
    }

    @InternalUseOnly
    public void setFamily(CipherFamily cipherFamily) {
        this.cipherFamily = cipherFamily;
    }

    public CipherFamily getFamily() {
        return this.cipherFamily;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setShouldCopyCustomProps(boolean bShouldCopyCustomProps) {
        this.bShouldCopyCustomProps = bShouldCopyCustomProps;
    }

    public boolean getShouldCopyCustomProps() {
        return this.bShouldCopyCustomProps;
    }

    public void validateInput() throws IonicException {
        String className = this.getClass().getName();
        SdkData.checkTrue(CipherFamily.FAMILY_UNKNOWN.equals((Object)this.cipherFamily), 40005, className);
        SdkData.checkTrue(null == this.getKeyResponse(), 40005, className);
        SdkData.checkTrue(null == this.getServerErrorResponse(), 40005, className);
    }
}

