/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.input;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.csv.input.CsvBodyInput;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericInput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.BytesTranscoder;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.ByteQueueInputStream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

@InternalUseOnly
final class Csv10BodyInput
implements CsvBodyInput {
    private final BufferedReader sourceReader;
    private final FileCryptoFileInfo fileInfo;
    private final FileCryptoDecryptAttributes decryptAttributes;
    private final ByteQueueInputStream targetStream;
    private ByteBuffer plainText;
    private final GenericInput genericInput;

    Csv10BodyInput(BufferedInputStream sourceStream, long sizeInput, KeyServices agent, FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes attributes) {
        this.sourceReader = new BufferedReader(new InputStreamReader((InputStream)sourceStream, StandardCharsets.UTF_8));
        this.fileInfo = fileInfo;
        this.decryptAttributes = attributes;
        this.targetStream = new ByteQueueInputStream(0x100000);
        this.genericInput = new GenericInput(this.targetStream, sizeInput, agent);
        this.plainText = this.genericInput.getPlainText();
    }

    @Override
    public void init() throws IonicException, IOException {
        String line = "";
        while (line != null && !line.contains("[IONIC-DATA-BEGIN]")) {
            line = this.sourceReader.readLine();
        }
        if (line == null || !line.contains("[IONIC-DATA-BEGIN]")) {
            throw new IonicException(80009);
        }
    }

    @Override
    public int available() throws IOException {
        return this.sourceReader.ready() ? 1 : this.genericInput.available();
    }

    @Override
    public ByteBuffer read() throws IonicException, IOException {
        BytesTranscoder transcoderBase64 = Transcoder.base64();
        boolean doneEmbedRead = false;
        while (!doneEmbedRead) {
            String line = this.sourceReader.readLine();
            if (line == null) {
                doneEmbedRead = true;
                continue;
            }
            if (line.contains("[IONIC-DATA-END]")) {
                doneEmbedRead = true;
                Logger.getLogger(this.getClass().getName()).fine(String.format("%s, %d bytes skipped", "[IONIC-DATA-END]", this.sourceReader.skip(Long.MAX_VALUE)));
                continue;
            }
            byte[] lineBytes = transcoderBase64.decode(line);
            this.targetStream.addBytes(lineBytes, 0, lineBytes.length);
            if (this.targetStream.available() < 10000016) continue;
            doneEmbedRead = true;
        }
        this.plainText.clear();
        if (this.decryptAttributes.getFamily().equals((Object)CipherFamily.FAMILY_UNKNOWN)) {
            this.plainText.limit(0);
            this.genericInput.init(this.fileInfo, this.decryptAttributes);
            this.fileInfo.setCipherFamily(CipherFamily.FAMILY_CSV);
            this.fileInfo.setCipherVersion("1.0");
        } else {
            this.plainText = this.genericInput.read();
        }
        return this.plainText;
    }

    @Override
    public void doFinal() throws IonicException {
        this.genericInput.doFinal();
        this.decryptAttributes.setFamily(CipherFamily.FAMILY_CSV);
        this.decryptAttributes.setVersion("1.0");
    }
}

