/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.input;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.StreamTokenFinder;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

@InternalUseOnly
final class CsvHeaderInput {
    public static final int MAX_HEADER_SIZE = "[IONIC-FILE-CSV-1.0]".length() + "[IONIC-DATA-BEGIN]".length() + 1000;

    CsvHeaderInput() {
    }

    public String read(InputStream is) throws IonicException {
        int i;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String token = null;
        StreamTokenFinder finderV10 = new StreamTokenFinder(Transcoder.utf8().decode("[IONIC-FILE-CSV-1.0]"));
        while ((i = DeviceUtils.readByte(is)) >= 0) {
            bos.write(i);
            byte b = (byte)i;
            if (finderV10.match(b)) {
                token = "|";
            } else if (bos.size() >= MAX_HEADER_SIZE) {
                throw new IonicException(80010);
            }
            if (token == null) continue;
            break;
        }
        if (token == null) {
            throw new IonicException(80009);
        }
        return Transcoder.utf8().encode(bos.toByteArray()).replace(token, "");
    }
}

