/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.input;

import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.csv.input.Csv10BodyInput;
import com.ionic.sdk.agent.cipher.file.family.csv.input.CsvBodyInput;
import com.ionic.sdk.agent.cipher.file.family.csv.input.CsvHeaderInput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@InternalUseOnly
public final class CsvInput {
    private final BufferedInputStream sourceStream;
    private final long sizeInput;
    private final KeyServices agent;
    private CsvBodyInput bodyInput;

    public CsvInput(InputStream inputStream, long sizeInput, KeyServices agent) {
        this.sourceStream = new BufferedInputStream(inputStream);
        this.sizeInput = sizeInput;
        this.agent = agent;
    }

    public void init(FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes decryptAttributes) throws IonicException, IOException {
        String ionicHeader = new CsvHeaderInput().read(this.sourceStream);
        if (!ionicHeader.contains("[IONIC-FILE-CSV-1.0]")) {
            throw new IonicException(80012);
        }
        this.bodyInput = new Csv10BodyInput(this.sourceStream, this.sizeInput, this.agent, fileInfo, decryptAttributes);
        this.bodyInput.init();
    }

    public int available() throws IonicException, IOException {
        if (this.bodyInput == null) {
            throw new IonicException(80012);
        }
        return this.bodyInput.available();
    }

    public ByteBuffer read() throws IOException, IonicException {
        if (this.bodyInput == null) {
            throw new IonicException(80012);
        }
        return this.bodyInput.read();
    }

    public void doFinal() throws IonicException {
        if (this.bodyInput == null) {
            throw new IonicException(80012);
        }
        this.bodyInput.doFinal();
    }
}

