/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.output;

import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.family.csv.output.CsvBodyOutput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericOutput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.ByteQueueOutputStream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@InternalUseOnly
final class Csv10BodyOutput
implements CsvBodyOutput {
    private final BufferedOutputStream targetStream;
    private final FileCryptoEncryptAttributes encryptAttributes;
    private final ByteQueueOutputStream byteQueueOutputStream;
    private final GenericOutput genericOutput;

    @Override
    public ByteBuffer getPlainText() {
        return this.genericOutput.getPlainText();
    }

    Csv10BodyOutput(BufferedOutputStream targetStream, long sizeInput, KeyServices agent, FileCryptoEncryptAttributes encryptAttributes) {
        this.targetStream = targetStream;
        this.encryptAttributes = encryptAttributes;
        this.byteQueueOutputStream = new ByteQueueOutputStream(0x100000);
        this.genericOutput = new GenericOutput(this.byteQueueOutputStream, sizeInput, agent);
    }

    @Override
    public void init() throws IOException, IonicException {
        this.targetStream.write(Transcoder.utf8().decode("[IONIC-DATA-BEGIN]"));
        this.targetStream.write(Transcoder.utf8().decode("\r\n"));
        FileCryptoEncryptAttributes encryptAttributesWrapped = new FileCryptoEncryptAttributes("1.2");
        encryptAttributesWrapped.setKeyAttributes(this.encryptAttributes.getKeyAttributes());
        encryptAttributesWrapped.setMutableKeyAttributes(this.encryptAttributes.getMutableKeyAttributes());
        encryptAttributesWrapped.setMetadata(this.encryptAttributes.getMetadata());
        this.genericOutput.init(encryptAttributesWrapped);
        this.targetStream.flush();
        this.encryptAttributes.setKeyResponse(encryptAttributesWrapped.getKeyResponse());
    }

    @Override
    public int getBlockLengthPlain() {
        return this.genericOutput.getBlockLengthPlain();
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException, IonicException {
        this.genericOutput.write(byteBuffer);
        byte[] data = new byte[60];
        while (this.byteQueueOutputStream.getByteQueue().available() >= 60) {
            int countRead = this.byteQueueOutputStream.getByteQueue().removeData(data, 0, data.length);
            this.targetStream.write(Transcoder.utf8().decode(Transcoder.base64().encode(Arrays.copyOf(data, countRead))));
            this.targetStream.write(Transcoder.utf8().decode("\r\n"));
        }
    }

    @Override
    public void doFinal() throws IOException {
        byte[] data = new byte[60];
        while (this.byteQueueOutputStream.getByteQueue().available() > 0) {
            int countToRead = Math.min(this.byteQueueOutputStream.getByteQueue().available(), 60);
            int countRead = this.byteQueueOutputStream.getByteQueue().removeData(data, 0, countToRead);
            this.targetStream.write(Transcoder.utf8().decode(Transcoder.base64().encode(Arrays.copyOf(data, countRead))));
            this.targetStream.write(Transcoder.utf8().decode("\r\n"));
        }
        this.targetStream.write(Transcoder.utf8().decode("[IONIC-DATA-END]"));
        this.targetStream.write(Transcoder.utf8().decode("\r\n"));
    }

    @Override
    public int getHeaderLengthWrapped() {
        return this.genericOutput.getHeaderLength();
    }

    @Override
    public byte[] getSignatureWrapped() throws IonicException {
        return this.genericOutput.getSignature();
    }
}

