/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.output;

import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.csv.output.Csv10BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.csv.output.CsvBodyOutput;
import com.ionic.sdk.agent.cipher.file.family.csv.output.CsvHeaderOutput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

@InternalUseOnly
public class CsvOutput {
    private final DataOutputStream dataOutputStream;
    private final long sizeInput;
    private final BufferedOutputStream targetStream;
    private final KeyServices agent;
    private final FileCryptoCoverPageServicesInterface coverPageServices;
    private CsvBodyOutput bodyOutput;
    private int headerLength;

    public ByteBuffer getPlainText() {
        return this.bodyOutput.getPlainText();
    }

    public CsvOutput(DataOutputStream outputStream, long sizeInput, KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        this.dataOutputStream = outputStream;
        this.sizeInput = sizeInput;
        this.targetStream = new BufferedOutputStream(outputStream);
        this.agent = agent;
        this.coverPageServices = coverPageServices;
    }

    public void init(FileCryptoEncryptAttributes encryptAttributes) throws IonicException, IOException {
        encryptAttributes.setFamily(CipherFamily.FAMILY_CSV);
        encryptAttributes.setVersion("1.0");
        String version = encryptAttributes.getVersion();
        SdkData.checkTrue(!Value.isEmpty(version), 80004);
        this.targetStream.write(this.coverPageServices.getCoverPage(FileType.FILETYPE_CSV));
        this.targetStream.write(Transcoder.utf8().decode("\""));
        this.targetStream.write(Transcoder.utf8().decode("\r\n"));
        this.targetStream.write(Transcoder.utf8().decode(new CsvHeaderOutput().write(version)));
        if (!"1.0".equals(version)) {
            throw new IonicException(80012);
        }
        this.bodyOutput = new Csv10BodyOutput(this.targetStream, this.sizeInput, this.agent, encryptAttributes);
        this.bodyOutput.init();
        this.headerLength = this.dataOutputStream.size();
    }

    public int getBlockLengthPlain() {
        return this.bodyOutput.getBlockLengthPlain();
    }

    public void write(ByteBuffer byteBuffer) throws IOException, IonicException {
        if (this.bodyOutput == null) {
            throw new IonicException(80012);
        }
        this.bodyOutput.write(byteBuffer);
    }

    public void doFinal() throws IOException {
        this.bodyOutput.doFinal();
        this.targetStream.write(Transcoder.utf8().decode("\""));
        this.targetStream.write(Transcoder.utf8().decode("\r\n"));
        this.targetStream.flush();
    }

    public int getHeaderLengthCsv() {
        return this.headerLength;
    }

    public int getHeaderLengthWrapped() {
        return this.bodyOutput.getHeaderLengthWrapped();
    }

    public byte[] getSignatureWrapped() throws IonicException {
        return this.bodyOutput.getSignatureWrapped();
    }
}

