/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.sig;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.StreamTokenFinder;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@InternalUseOnly
public final class CsvSignerBytes {
    private final ByteBuffer byteBuffer;

    public CsvSignerBytes(byte[] bytes) {
        this.byteBuffer = ByteBuffer.wrap(bytes);
    }

    public void apply(byte[] signature, int headerLengthCsv, int position) throws IonicException {
        try {
            this.applyInternal(signature, headerLengthCsv, position);
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }

    private void applyInternal(byte[] signature, int headerLengthCsv, int position) throws IOException {
        int countDelimiter = "\r\n".length();
        this.byteBuffer.position(headerLengthCsv);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int countEnoughBytes = position + 48;
        while (bos.size() < countEnoughBytes) {
            int beginLine = this.byteBuffer.position();
            StreamTokenFinder finderEOL = new StreamTokenFinder(Transcoder.utf8().decode("\r\n"));
            boolean match = false;
            while (!match) {
                match = finderEOL.match(this.byteBuffer.get());
            }
            int endLine = this.byteBuffer.position();
            byte[] bytes = Arrays.copyOfRange(this.byteBuffer.array(), beginLine, endLine - countDelimiter);
            bos.write(Transcoder.base64().decode(Transcoder.utf8().encode(bytes)));
        }
        byte[] bytesToApply = bos.toByteArray();
        System.arraycopy(signature, 0, bytesToApply, position, signature.length);
        int cursorCsv = headerLengthCsv;
        for (int cursorEmbed = 0; cursorEmbed < bytesToApply.length; cursorEmbed += 60) {
            int length = Math.min(60, bytesToApply.length - cursorEmbed);
            byte[] bytesLine = Transcoder.utf8().decode(Transcoder.base64().encode(Arrays.copyOfRange(bytesToApply, cursorEmbed, cursorEmbed + length)));
            System.arraycopy(bytesLine, 0, this.byteBuffer.array(), cursorCsv, bytesLine.length);
            cursorCsv += 80 + countDelimiter;
        }
    }
}

