/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.csv.sig;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.StreamTokenFinder;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

@InternalUseOnly
public final class CsvSignerFile {
    private final FileChannel fileChannel;

    public CsvSignerFile(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public void apply(byte[] signature, int headerLengthCsv, int position) throws IonicException {
        try {
            this.applyInternal(signature, headerLengthCsv, position);
        }
        catch (IOException e) {
            throw new IonicException(80014, (Throwable)e);
        }
    }

    private void applyInternal(byte[] signature, int headerLengthCsv, int position) throws IOException, IonicException {
        int countDelimiter = "\r\n".length();
        int countLineBase64 = 80 + countDelimiter;
        this.fileChannel.position(headerLengthCsv);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int countEnoughBytes = position + 48;
        int countEnoughLines = countEnoughBytes / 60 + 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(countEnoughLines * countLineBase64);
        int read = this.fileChannel.read(byteBuffer);
        if (read != countEnoughLines * countLineBase64) {
            throw new IonicException(80014);
        }
        this.fileChannel.position(headerLengthCsv);
        byteBuffer.position(0);
        while (bos.size() < countEnoughBytes) {
            int beginLine = byteBuffer.position();
            StreamTokenFinder finderEOL = new StreamTokenFinder(Transcoder.utf8().decode("\r\n"));
            boolean match = false;
            while (!match) {
                match = finderEOL.match(byteBuffer.get());
            }
            int endLine = byteBuffer.position();
            byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), beginLine, endLine - countDelimiter);
            bos.write(Transcoder.base64().decode(Transcoder.utf8().encode(bytes)));
        }
        byte[] bytesToApply = bos.toByteArray();
        System.arraycopy(signature, 0, bytesToApply, position, signature.length);
        for (int cursorEmbed = 0; cursorEmbed < bytesToApply.length; cursorEmbed += 60) {
            int length = Math.min(60, bytesToApply.length - cursorEmbed);
            byte[] bytesLine = Transcoder.utf8().decode(Transcoder.base64().encode(Arrays.copyOfRange(bytesToApply, cursorEmbed, cursorEmbed + length)));
            ByteBuffer byteBufferWrite = ByteBuffer.wrap(bytesLine);
            this.fileChannel.write(byteBufferWrite);
            this.fileChannel.position(this.fileChannel.position() + 2L);
        }
    }
}

