/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.input;

import com.ionic.sdk.agent.cipher.file.data.FileCipher;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericBodyInput;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@InternalUseOnly
final class Generic11BodyInput
implements GenericBodyInput {
    private final BufferedInputStream sourceStream;
    private final AgentKey key;
    private final AesCtrCipher cipher;

    Generic11BodyInput(BufferedInputStream sourceStream, AgentKey key) throws IonicException {
        this.sourceStream = sourceStream;
        this.key = key;
        this.cipher = new AesCtrCipher();
        if (key != null) {
            this.cipher.setKey(key.getKey());
        }
    }

    @Override
    public void init() {
    }

    @Override
    public ByteBuffer read() throws IOException, IonicException {
        byte[] block;
        byte[] blockMax = new byte[10946];
        int count = this.sourceStream.read(blockMax);
        byte[] byArray = block = 10946 == count ? blockMax : Arrays.copyOf(blockMax, count);
        if (block[0] != FileCipher.Generic.V11.BLOCK_HEADER_BYTE) {
            throw new IonicException(80011);
        }
        if (block[count - 1] != FileCipher.Generic.V11.BLOCK_FOOTER_BYTE) {
            throw new IonicException(80011);
        }
        String blockBase64 = Transcoder.utf8().encode(Arrays.copyOfRange(blockMax, 1, count - 1));
        return ByteBuffer.wrap(this.key == null ? Transcoder.base64().decode(blockBase64) : this.cipher.decryptBase64(blockBase64));
    }

    @Override
    public void doFinal() {
    }
}

