/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.input;

import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericBodyInput;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;

@InternalUseOnly
final class Generic12BodyInput
implements GenericBodyInput {
    private final BufferedInputStream sourceStream;
    private final AgentKey key;
    private final ByteBuffer plainText;
    private final ByteBuffer cipherText;
    private final AesCtrCipher cipher;
    private final ByteArrayOutputStream plainTextBlockHashes;
    private byte[] hashOfHashesCipherText;

    Generic12BodyInput(BufferedInputStream sourceStream, AgentKey key, ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        this.sourceStream = sourceStream;
        this.plainText = plainText;
        this.cipherText = cipherText;
        this.key = key;
        this.cipher = new AesCtrCipher();
        if (key != null) {
            this.cipher.setKey(key.getKey());
        }
        this.plainTextBlockHashes = new ByteArrayOutputStream();
    }

    @Override
    public void init() throws IonicException {
        byte[] bytesCipherText = new byte[48];
        try {
            int count = this.sourceStream.read(bytesCipherText);
            SdkData.checkTrue(48 == count, 80009);
        }
        catch (IOException e) {
            throw new IonicException(80009, (Throwable)e);
        }
        this.hashOfHashesCipherText = bytesCipherText;
    }

    @Override
    public ByteBuffer read() throws IOException, IonicException {
        ReadableByteChannel readableChannel = Channels.newChannel(this.sourceStream);
        this.cipherText.clear();
        int blockSize = readableChannel.read(this.cipherText);
        this.cipherText.limit(blockSize);
        this.cipherText.position(0);
        if (this.key != null) {
            this.cipher.decrypt(this.plainText, this.cipherText);
        }
        this.plainText.limit(this.plainText.position());
        this.plainText.position(0);
        if (this.key != null) {
            byte[] plainTextBlockHash = CryptoUtils.hmacSHA256(this.plainText, this.key.getKey());
            this.plainTextBlockHashes.write(plainTextBlockHash);
        }
        this.plainText.limit(this.plainText.position());
        this.plainText.position(0);
        return this.plainText;
    }

    @Override
    public void doFinal() throws IonicException {
        byte[] hashOfHashesExpected = this.cipher.decrypt(this.hashOfHashesCipherText);
        byte[] hashOfHashesActual = CryptoUtils.hmacSHA256(this.plainTextBlockHashes.toByteArray(), this.key.getKey());
        boolean verified = Arrays.equals(hashOfHashesExpected, hashOfHashesActual);
        SdkData.checkTrue(verified, 80013);
    }
}

