/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.input;

import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericBodyInput;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericHeaderInput;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.BytesReader;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.json.JsonObject;

@InternalUseOnly
final class Generic13BodyInput
implements GenericBodyInput {
    private final BufferedInputStream sourceStream;
    private final KeyServices agent;
    private final AgentKey key;
    private final int metaSize;
    private int blockIndex;
    private final ByteBuffer plainText;
    private final ByteBuffer cipherText;
    private final AesGcmCipher cipher;

    Generic13BodyInput(BufferedInputStream sourceStream, KeyServices agent, AgentKey key, int blockSize, int metaSize, ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        this.sourceStream = sourceStream;
        this.agent = agent;
        this.key = key;
        this.metaSize = metaSize;
        this.blockIndex = 0;
        this.plainText = plainText;
        this.cipherText = cipherText;
        this.cipher = new AesGcmCipher();
        if (key != null) {
            this.cipher.setKey(key.getKey());
            this.cipher.setAuthData(Transcoder.utf8().decode(key.getId()));
        }
    }

    @Override
    public void init() {
    }

    @Override
    public ByteBuffer read() throws IOException, IonicException {
        if (this.blockIndex > 0 && this.blockIndex % this.metaSize == 0) {
            String ionicHeader = new GenericHeaderInput().read(this.sourceStream);
            JsonObject jsonHeader = JsonIO.readObject(ionicHeader, 80011);
            String tag = JsonSource.getString(jsonHeader, "tag");
            SdkData.checkTrue(!Value.isEmpty(tag), 80004);
            GetKeysResponse.Key keyRotate = this.agent.getKey(tag).getFirstKey();
            this.cipher.setKey(keyRotate.getKey());
            this.cipher.setAuthData(Transcoder.utf8().decode(keyRotate.getId()));
        }
        ReadableByteChannel readableChannel = Channels.newChannel(this.sourceStream);
        this.cipherText.clear();
        this.cipherText.limit(4);
        int countInteger = readableChannel.read(this.cipherText);
        SdkData.checkTrue(this.cipherText.limit() == countInteger, 80009);
        int sizeBlock = BytesReader.readInt(this.cipherText.array(), 0, this.cipherText.limit());
        this.cipherText.clear();
        this.cipherText.limit(sizeBlock);
        int countBlock = readableChannel.read(this.cipherText);
        SdkData.checkTrue(sizeBlock == countBlock, 80009);
        this.cipherText.limit(this.cipherText.position());
        this.cipherText.position(0);
        this.plainText.limit(this.cipherText.limit());
        this.plainText.position(0);
        if (this.key != null) {
            this.cipher.decrypt(this.plainText, this.cipherText);
        }
        this.plainText.limit(this.plainText.position());
        this.plainText.position(0);
        ++this.blockIndex;
        return this.plainText;
    }

    @Override
    public void doFinal() {
    }
}

