/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.input;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.StreamTokenFinder;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

@InternalUseOnly
final class GenericHeaderInput {
    private static final int MAX_HEADER_SIZE_DEFAULT = 10000;

    GenericHeaderInput() {
    }

    public String read(InputStream is) throws IonicException {
        int i;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String token = null;
        StreamTokenFinder finderV11 = new StreamTokenFinder(Transcoder.utf8().decode("|"));
        StreamTokenFinder finderV12 = new StreamTokenFinder(Transcoder.utf8().decode("\r\n\r\n"));
        while ((i = DeviceUtils.readByte(is)) >= 0) {
            bos.write(i);
            byte b = (byte)i;
            if (finderV11.match(b)) {
                token = "|";
            } else if (finderV12.match(b)) {
                token = "\r\n\r\n";
            } else if (bos.size() >= 10000) {
                throw new IonicException(80010);
            }
            if (token == null) continue;
            break;
        }
        if (token == null) {
            throw new IonicException(80009);
        }
        return Transcoder.utf8().encode(bos.toByteArray()).replace(token, "");
    }
}

