/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.input;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.generic.input.Generic11BodyInput;
import com.ionic.sdk.agent.cipher.file.family.generic.input.Generic12BodyInput;
import com.ionic.sdk.agent.cipher.file.family.generic.input.Generic13BodyInput;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericBodyInput;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericHeaderInput;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.json.JsonObject;

@InternalUseOnly
public final class GenericInput {
    private final BufferedInputStream sourceStream;
    private final KeyServices agent;
    private final ByteBuffer plainText;
    private final ByteBuffer cipherText;
    private GenericBodyInput bodyInput;

    public ByteBuffer getPlainText() {
        return this.plainText;
    }

    public ByteBuffer getCipherText() {
        return this.cipherText;
    }

    public GenericInput(InputStream inputStream, long sizeInput, KeyServices agent) {
        this.sourceStream = new BufferedInputStream(inputStream);
        this.agent = agent;
        int sizeBlockCipher = Math.max(16, (int)Math.min(sizeInput, 10000016L));
        this.plainText = ByteBuffer.allocate(sizeBlockCipher - 16);
        this.cipherText = ByteBuffer.allocate(sizeBlockCipher);
    }

    public void init(FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes decryptAttributes) throws IonicException {
        GetKeysResponse.Key key;
        JsonObject jsonHeader;
        try {
            String ionicHeader = new GenericHeaderInput().read(this.sourceStream);
            jsonHeader = JsonIO.readObject(ionicHeader, 80011);
        }
        catch (IonicException e) {
            fileInfo.setCipherFamily(CipherFamily.FAMILY_GENERIC);
            fileInfo.setCipherVersion("1.3");
            throw e;
        }
        String family = Value.defaultOnEmpty(JsonSource.getString(jsonHeader, "family"), "generic");
        SdkData.checkTrue("generic".equals(family), 80017);
        String version = JsonSource.getString(jsonHeader, "version");
        SdkData.checkTrue(!Value.isEmpty(version), 80004);
        String tag = JsonSource.getString(jsonHeader, "tag");
        String server = JsonSource.getString(jsonHeader, "server");
        boolean isV11 = "1.1".equals(version);
        boolean isV12 = "1.2".equals(version);
        boolean isV13 = "1.3".equals(version);
        boolean isTagged = !Value.isEmpty(tag);
        SdkData.checkTrue((isV11 || isV12 || isV13) && isTagged, 80012);
        fileInfo.setEncrypted(true);
        fileInfo.setCipherFamily(CipherFamily.FAMILY_GENERIC);
        fileInfo.setCipherVersion(version);
        fileInfo.setKeyId(tag);
        fileInfo.setServer(server);
        decryptAttributes.validateInput();
        decryptAttributes.setFamily(CipherFamily.FAMILY_GENERIC);
        decryptAttributes.setVersion(version);
        GetKeysResponse.Key key2 = key = this.agent == null ? null : this.agent.getKey(tag).getFirstKey();
        if (isV11) {
            this.bodyInput = new Generic11BodyInput(this.sourceStream, key);
        } else if (isV12) {
            this.bodyInput = new Generic12BodyInput(this.sourceStream, key, this.plainText, this.cipherText);
        } else if (isV13) {
            int blockSize = JsonSource.getInt(jsonHeader, "block_size");
            int metaSize = JsonSource.getInt(jsonHeader, "meta_size");
            this.bodyInput = new Generic13BodyInput(this.sourceStream, this.agent, key, blockSize, metaSize, this.plainText, this.cipherText);
        } else {
            throw new IonicException(80012);
        }
        if (key != null) {
            decryptAttributes.setKeyResponse(key);
        }
        this.bodyInput.init();
    }

    public int available() throws IOException {
        return this.sourceStream.available();
    }

    public ByteBuffer read() throws IOException, IonicException {
        if (this.bodyInput == null) {
            throw new IonicException(80012);
        }
        return this.bodyInput.read();
    }

    public void doFinal() throws IonicException {
        this.bodyInput.doFinal();
    }
}

