/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.output;

import com.ionic.sdk.agent.cipher.file.data.FileCipher;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericBodyOutput;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

@InternalUseOnly
final class Generic11BodyOutput
implements GenericBodyOutput {
    private final BufferedOutputStream targetStream;
    private final AesCtrCipher cipher;

    Generic11BodyOutput(BufferedOutputStream targetStream, AesCtrCipher cipher) {
        this.targetStream = targetStream;
        this.cipher = cipher;
    }

    @Override
    public int init() {
        return 0;
    }

    @Override
    public int getBlockLengthPlain() {
        return 8192;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, IonicException {
        byte[] plainText = new byte[byteBuffer.remaining()];
        byteBuffer.get(plainText);
        byte[] cipherText = Transcoder.utf8().decode(this.cipher.encryptToBase64(plainText));
        this.targetStream.write(FileCipher.Generic.V11.BLOCK_HEADER_BYTE);
        this.targetStream.write(cipherText);
        this.targetStream.write(FileCipher.Generic.V11.BLOCK_FOOTER_BYTE);
        return 1 + cipherText.length + 1;
    }

    @Override
    public void doFinal() {
    }

    @Override
    public byte[] getSignature() {
        return null;
    }
}

