/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.output;

import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericBodyOutput;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.error.IonicException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

@InternalUseOnly
final class Generic12BodyOutput
implements GenericBodyOutput {
    private final BufferedOutputStream targetStream;
    private final AesCtrCipher cipher;
    private final AgentKey key;
    private final ByteBuffer plainText;
    private final ByteBuffer cipherText;
    private final ByteArrayOutputStream plainTextBlockHashes;

    Generic12BodyOutput(BufferedOutputStream targetStream, AesCtrCipher cipher, AgentKey key, ByteBuffer plainText, ByteBuffer cipherText) {
        this.targetStream = targetStream;
        this.plainTextBlockHashes = new ByteArrayOutputStream();
        this.cipher = cipher;
        this.key = key;
        this.plainText = plainText;
        this.cipherText = cipherText;
    }

    @Override
    public int init() throws IOException {
        this.targetStream.write(new byte[48]);
        return 48;
    }

    @Override
    public int getBlockLengthPlain() {
        return 10000000;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, IonicException {
        byte[] plainTextBlockHash = CryptoUtils.hmacSHA256(byteBuffer, this.key.getKey());
        this.plainTextBlockHashes.write(plainTextBlockHash);
        this.plainText.position(0);
        int encryptedLen = this.cipher.encrypt(this.plainText, this.cipherText);
        WritableByteChannel cipherChannel = Channels.newChannel(this.targetStream);
        this.cipherText.limit(this.cipherText.position());
        this.cipherText.position(0);
        cipherChannel.write(this.cipherText);
        this.targetStream.flush();
        return encryptedLen;
    }

    @Override
    public void doFinal() {
    }

    @Override
    public byte[] getSignature() throws IonicException {
        byte[] blockHashes = this.plainTextBlockHashes.toByteArray();
        byte[] hmacSHA256 = CryptoUtils.hmacSHA256(blockHashes, this.key.getKey());
        return this.cipher.encrypt(hmacSHA256);
    }
}

