/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.output;

import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericBodyOutput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericHeaderOutput;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.json.JsonTarget;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.json.Json;
import javax.json.JsonObjectBuilder;

@InternalUseOnly
final class Generic13BodyOutput
implements GenericBodyOutput {
    private final BufferedOutputStream targetStream;
    private final KeyServices agent;
    private final AgentKey key;
    private final AesGcmCipher cipher;
    private final int blockSize;
    private final int metaSize;
    private int blockIndex;
    private final ByteBuffer plainText;
    private final ByteBuffer cipherText;

    Generic13BodyOutput(BufferedOutputStream targetStream, KeyServices agent, AgentKey key, int blockSize, int metaSize, ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        this.targetStream = targetStream;
        this.agent = agent;
        this.key = key;
        this.cipher = new AesGcmCipher(key.getKey());
        this.cipher.setAuthData(Transcoder.utf8().decode(key.getId()));
        this.blockSize = blockSize;
        this.metaSize = metaSize;
        this.blockIndex = 0;
        this.plainText = plainText;
        this.cipherText = cipherText;
    }

    @Override
    public int init() {
        return 0;
    }

    @Override
    public int getBlockLengthPlain() {
        return this.blockSize;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, IonicException {
        DataOutputStream dos = new DataOutputStream(this.targetStream);
        if (this.blockIndex > 0 && this.blockIndex % this.metaSize == 0) {
            CreateKeysResponse createKeysResponse = this.agent.createKey(this.key.getAttributesMap(), this.key.getMutableAttributesMap());
            CreateKeysResponse.Key keyRotate = createKeysResponse.getFirstKey();
            this.cipher.setKey(keyRotate.getKey());
            this.cipher.setAuthData(Transcoder.utf8().decode(keyRotate.getId()));
            JsonObjectBuilder jsonHeaderBuilder = Json.createObjectBuilder();
            JsonTarget.addNotNull(jsonHeaderBuilder, "tag", keyRotate.getId());
            String headerText = new GenericHeaderOutput().write(jsonHeaderBuilder, "1.3");
            dos.write(Transcoder.utf8().decode(headerText));
        }
        this.plainText.position(0);
        int encryptedLen = this.cipher.encrypt(this.plainText, this.cipherText);
        dos.writeInt(encryptedLen);
        WritableByteChannel cipherChannel = Channels.newChannel(this.targetStream);
        this.cipherText.limit(this.cipherText.position());
        this.cipherText.position(0);
        cipherChannel.write(this.cipherText);
        this.targetStream.flush();
        ++this.blockIndex;
        return encryptedLen;
    }

    @Override
    public void doFinal() {
    }

    @Override
    public byte[] getSignature() {
        return null;
    }
}

