/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.generic.output;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.family.generic.output.Generic11BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.Generic12BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.Generic13BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericBodyOutput;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericHeaderOutput;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.json.JsonTarget;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.json.Json;
import javax.json.JsonObjectBuilder;

@InternalUseOnly
public final class GenericOutput {
    private final BufferedOutputStream targetStream;
    private final long sizeInput;
    private final KeyServices agent;
    private ByteBuffer plainText;
    private ByteBuffer cipherText;
    private GenericBodyOutput bodyOutput;
    private int headerLength;
    private int outputLength;

    public ByteBuffer getPlainText() {
        return this.plainText;
    }

    public ByteBuffer getCipherText() {
        return this.cipherText;
    }

    public GenericOutput(OutputStream outputStream, long sizeInput, KeyServices agent) {
        this.targetStream = new BufferedOutputStream(outputStream);
        this.sizeInput = sizeInput;
        this.agent = agent;
    }

    public int init(FileCryptoEncryptAttributes encryptAttributes) throws IonicException, IOException {
        AesCtrCipher cipher;
        encryptAttributes.validateInput();
        String version = Value.defaultOnEmpty(encryptAttributes.getVersion(), "1.3");
        CreateKeysResponse createKeysResponse = this.agent.createKey(encryptAttributes.getKeyAttributes(), encryptAttributes.getMutableKeyAttributes());
        CreateKeysResponse.Key createKey = createKeysResponse.getFirstKey();
        createKey.setAttributesMap(encryptAttributes.getKeyAttributes());
        createKey.setMutableAttributesMap(encryptAttributes.getMutableKeyAttributes());
        encryptAttributes.setKeyResponse(createKey);
        encryptAttributes.setFamily(CipherFamily.FAMILY_GENERIC);
        encryptAttributes.setVersion(version);
        JsonObjectBuilder jsonHeaderBuilder = Json.createObjectBuilder();
        if ("1.1".equals(version)) {
            cipher = new AesCtrCipher(createKey.getKey());
            this.plainText = ByteBuffer.allocate(8192);
            this.cipherText = ByteBuffer.allocate(8208);
            this.bodyOutput = new Generic11BodyOutput(this.targetStream, cipher);
        } else if ("1.2".equals(version)) {
            JsonTarget.addNotNull(jsonHeaderBuilder, "family", "generic");
            cipher = new AesCtrCipher(createKey.getKey());
            int sizeBlock = (int)Math.min(this.sizeInput, 10000000L);
            this.plainText = ByteBuffer.allocate(sizeBlock);
            this.cipherText = ByteBuffer.allocate(sizeBlock + 16);
            this.bodyOutput = new Generic12BodyOutput(this.targetStream, cipher, createKey, this.plainText, this.cipherText);
        } else if ("1.3".equals(version)) {
            String propMetaSize = encryptAttributes.getProperty("meta_size");
            String propBlockSize = encryptAttributes.getProperty("block_size");
            int metaSize = Value.toInt(propMetaSize, 4096);
            int blockSize = Value.toInt(propBlockSize, 0x800000);
            JsonTarget.addNotNull(jsonHeaderBuilder, "family", "generic");
            JsonTarget.add(jsonHeaderBuilder, "block_size", blockSize);
            JsonTarget.add(jsonHeaderBuilder, "meta_size", metaSize);
            this.plainText = ByteBuffer.allocate(blockSize);
            this.cipherText = ByteBuffer.allocate(blockSize + 16 + 16);
            this.bodyOutput = new Generic13BodyOutput(this.targetStream, this.agent, createKey, blockSize, metaSize, this.plainText, this.cipherText);
        } else {
            throw new IonicException(80012);
        }
        JsonTarget.addNotNull(jsonHeaderBuilder, "version", version);
        JsonTarget.addNotNull(jsonHeaderBuilder, "server", this.agent.getActiveProfile().getServer());
        JsonTarget.addNotNull(jsonHeaderBuilder, "tag", createKey.getId());
        String headerText = new GenericHeaderOutput().write(jsonHeaderBuilder, version);
        byte[] header = Transcoder.utf8().decode(headerText);
        this.headerLength = header.length;
        this.targetStream.write(header);
        int countBodyInit = this.bodyOutput.init();
        this.outputLength += this.headerLength + countBodyInit;
        return this.headerLength + countBodyInit;
    }

    public int getBlockLengthPlain() {
        return this.bodyOutput.getBlockLengthPlain();
    }

    public int write(ByteBuffer byteBuffer) throws IOException, IonicException {
        if (this.bodyOutput == null) {
            throw new IonicException(80012);
        }
        int write = this.bodyOutput.write(byteBuffer);
        this.outputLength += write;
        return write;
    }

    public void doFinal() throws IOException {
        this.bodyOutput.doFinal();
        this.targetStream.flush();
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public byte[] getSignature() throws IonicException {
        return this.bodyOutput.getSignature();
    }

    public int getSignatureOffset() {
        return this.headerLength;
    }

    public int getOutputLength() {
        return this.outputLength;
    }
}

