/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml;

import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.core.datastructures.Tuple;
import com.ionic.sdk.error.IonicException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class OpenXmlUtils {
    private static final Logger LOGGER = Logger.getLogger(OpenXmlUtils.class.getName());

    private OpenXmlUtils() {
    }

    public static Tuple<FileType, byte[]> doFirstPassThrough(File fileToEncrypt, boolean getCustomProps) throws IonicException {
        ZipFile zip;
        LOGGER.fine(String.format("filename = %s", fileToEncrypt.getName()));
        FileType fileType = FileType.FILETYPE_UNKNOWN;
        byte[] customPropsFile = null;
        try {
            zip = new ZipFile(fileToEncrypt, 1);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80008, (Throwable)e);
        }
        ZipEntry content = zip.getEntry("word/document.xml");
        if (null != content) {
            fileType = OpenXmlUtils.findContentTypeIsMacro(zip, "application/vnd.ms-word.document.macroEnabled.main+xml") ? FileType.FILETYPE_DOCM : FileType.FILETYPE_DOCX;
        }
        if (null != (content = zip.getEntry("ppt/presentation.xml"))) {
            fileType = OpenXmlUtils.findContentTypeIsMacro(zip, "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml") ? FileType.FILETYPE_PPTM : FileType.FILETYPE_PPTX;
        }
        if (null != (content = zip.getEntry("xl/workbook.xml"))) {
            fileType = OpenXmlUtils.findContentTypeIsMacro(zip, "application/vnd.ms-excel.sheet.macroEnabled.main+xml") ? FileType.FILETYPE_XLSM : FileType.FILETYPE_XLSX;
        }
        if (getCustomProps) {
            customPropsFile = OpenXmlUtils.inflateZipArchive(zip, "docProps/custom.xml");
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Tuple<FileType, byte[]>(fileType, customPropsFile);
    }

    public static Tuple<FileType, byte[]> doFirstPassThrough(InputStream sourceStream, boolean getCustomProps) throws IonicException {
        boolean foundDocx = false;
        boolean foundPPtx = false;
        boolean foundXlsx = false;
        byte[] contentBytes = null;
        Document contentDoc = null;
        FileType fileType = FileType.FILETYPE_UNKNOWN;
        byte[] customPropsFile = null;
        try {
            ZipInputStream zip = new ZipInputStream(sourceStream);
            ZipEntry zipEntry = null;
            while (null != (zipEntry = zip.getNextEntry())) {
                if ("[Content_Types].xml".equals(zipEntry.getName())) {
                    contentBytes = OpenXmlUtils.readZipEntryInternal(zip);
                    continue;
                }
                if ("docProps/custom.xml".equals(zipEntry.getName()) && getCustomProps) {
                    customPropsFile = OpenXmlUtils.readZipEntryInternal(zip);
                    continue;
                }
                if ("word/document.xml".equals(zipEntry.getName())) {
                    foundDocx = true;
                    continue;
                }
                if ("ppt/presentation.xml".equals(zipEntry.getName())) {
                    foundPPtx = true;
                    continue;
                }
                if (!"xl/workbook.xml".equals(zipEntry.getName())) continue;
                foundXlsx = true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80008, (Throwable)e);
        }
        String searchName = "";
        if (foundDocx) {
            searchName = "application/vnd.ms-word.document.macroEnabled.main+xml";
        } else if (foundPPtx) {
            searchName = "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml";
        } else if (foundXlsx) {
            searchName = "application/vnd.ms-excel.sheet.macroEnabled.main+xml";
        }
        boolean foundMacro = false;
        if (contentBytes != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                contentDoc = builder.parse(new ByteArrayInputStream(contentBytes));
                contentDoc.getDocumentElement().normalize();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                throw new IonicException(80016, (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                throw new IonicException(80016, (Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                throw new IonicException(80016, (Throwable)e);
            }
            NodeList nList = contentDoc.getElementsByTagName("Override");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element eElement;
                String contentType;
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1 || !searchName.equals(contentType = (eElement = (Element)nNode).getAttribute("ContentType"))) continue;
                foundMacro = true;
            }
        }
        fileType = foundDocx ? (foundMacro ? FileType.FILETYPE_DOCM : FileType.FILETYPE_DOCX) : (foundPPtx ? (foundMacro ? FileType.FILETYPE_PPTM : FileType.FILETYPE_PPTX) : (foundXlsx ? (foundMacro ? FileType.FILETYPE_XLSM : FileType.FILETYPE_XLSX) : FileType.FILETYPE_UNKNOWN));
        return new Tuple<FileType, byte[]>(fileType, customPropsFile);
    }

    private static boolean findContentTypeIsMacro(ZipFile zip, String searchName) throws IonicException {
        LOGGER.fine(String.format("searchName = %s", searchName));
        Document doc = OpenXmlUtils.inflateZipArchiveXml(zip, "[Content_Types].xml");
        if (doc == null) {
            LOGGER.fine(String.format("archive = %s was not found.", "[Content_Types].xml"));
            return false;
        }
        NodeList nList = doc.getElementsByTagName("Override");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Element eElement;
            String contentType;
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1 || !searchName.equals(contentType = (eElement = (Element)nNode).getAttribute("ContentType"))) continue;
            return true;
        }
        LOGGER.fine(String.format("node = %s was not found.", searchName));
        return false;
    }

    public static Document getContentsXml(ZipFile zip) throws IonicException {
        return OpenXmlUtils.inflateZipArchiveXml(zip, "[Content_Types].xml");
    }

    public static Document getPowerPointDocumentXml(ZipFile zip) throws IonicException {
        return OpenXmlUtils.inflateZipArchiveXml(zip, "ppt/presentation.xml");
    }

    public static Document getExcelDocumentXml(ZipFile zip) throws IonicException {
        return OpenXmlUtils.inflateZipArchiveXml(zip, "xl/workbook.xml");
    }

    public static Document getWordDocumentXml(ZipFile zip) throws IonicException {
        return OpenXmlUtils.inflateZipArchiveXml(zip, "word/document.xml");
    }

    public static Tuple<Document, Document> getContentsAndRelationsFilesFromStream(InputStream is) throws IonicException {
        byte[] contentBytes = null;
        byte[] relationBytes = null;
        Document contents = null;
        Document relations = null;
        try {
            ZipInputStream zip = new ZipInputStream(is);
            ZipEntry zipEntry = null;
            while (null != (zipEntry = zip.getNextEntry())) {
                if ("[Content_Types].xml".equals(zipEntry.getName())) {
                    contentBytes = OpenXmlUtils.readZipEntryInternal(zip);
                    continue;
                }
                if (!"_rels/.rels".equals(zipEntry.getName())) continue;
                relationBytes = OpenXmlUtils.readZipEntryInternal(zip);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80008, (Throwable)e);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (contentBytes != null) {
                contents = builder.parse(new ByteArrayInputStream(contentBytes));
                contents.getDocumentElement().normalize();
            }
            if (relationBytes != null) {
                relations = builder.parse(new ByteArrayInputStream(relationBytes));
                relations.getDocumentElement().normalize();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80016, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80016, (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80016, (Throwable)e);
        }
        return new Tuple<Document, Object>(contents, relations);
    }

    public static void registerOpenXmlContentType(Document doc, String sExtension, String sContentType) {
        boolean bFound = false;
        NodeList nList = doc.getElementsByTagName("Default");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Element eElement;
            String extensionAttr;
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1 || !Objects.equals(sExtension, extensionAttr = (eElement = (Element)nNode).getAttribute("Extension"))) continue;
            bFound = true;
            eElement.setAttribute("Extension", sExtension);
            eElement.setAttribute("ContentType", sContentType);
        }
        if (!bFound) {
            Element eElement = doc.createElement("Default");
            eElement.setAttribute("Extension", sExtension);
            eElement.setAttribute("ContentType", sContentType);
            doc.getDocumentElement().appendChild(eElement);
        }
    }

    public static void registerOpenXmlContentTypeOverride(Document doc, String sPartName, String sContentType) {
        boolean bFound = false;
        NodeList nList = doc.getElementsByTagName("Override");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Element eElement;
            String partNameAttr;
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1 || !Objects.equals(sPartName, partNameAttr = (eElement = (Element)nNode).getAttribute("PartName"))) continue;
            bFound = true;
            eElement.setAttribute("PartName", sPartName);
            eElement.setAttribute("ContentType", sContentType);
        }
        if (!bFound) {
            Element eElement = doc.createElement("Override");
            eElement.setAttribute("PartName", sPartName);
            eElement.setAttribute("ContentType", sContentType);
            doc.getDocumentElement().appendChild(eElement);
        }
    }

    public static void registerOpenXmlRelationship(Document doc, String sType, String sTarget, String sId) {
        boolean bFound = false;
        Element rootNode = doc.getDocumentElement();
        if ("Relationships".equals(rootNode.getNodeName())) {
            NodeList nList = doc.getElementsByTagName("Relationship");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element eElement;
                String targetAttr;
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1 || !Objects.equals(sTarget, targetAttr = (eElement = (Element)nNode).getAttribute("Target"))) continue;
                bFound = true;
                eElement.setAttribute("Id", sId);
                eElement.setAttribute("Target", sTarget);
                eElement.setAttribute("Type", sType);
            }
            if (!bFound) {
                Element eElement = doc.createElement("Relationship");
                eElement.setAttribute("Id", sId);
                eElement.setAttribute("Target", sTarget);
                eElement.setAttribute("Type", sType);
                rootNode.appendChild(eElement);
            }
        }
    }

    private static byte[] inflateZipArchive(ZipFile zip, String archiveName) throws IonicException {
        byte[] output = null;
        ZipEntry content = zip.getEntry(archiveName);
        if (null == content) {
            return null;
        }
        try {
            InputStream ins = zip.getInputStream(content);
            output = OpenXmlUtils.readZipEntryInternal(ins);
            ins.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80008, (Throwable)e);
        }
        return output;
    }

    private static Document inflateZipArchiveXml(ZipFile zip, String archiveName) throws IonicException {
        LOGGER.fine(String.format("archiveName = %s", archiveName));
        ZipEntry content = zip.getEntry(archiveName);
        if (null == content) {
            LOGGER.fine(String.format("archive = %s was not found.", archiveName));
            return null;
        }
        try {
            InputStream ins = zip.getInputStream(content);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(ins);
            doc.getDocumentElement().normalize();
            ins.close();
            return doc;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80008, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80011, (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new IonicException(80011, (Throwable)e);
        }
    }

    public static byte[] readZipEntry(ZipInputStream zis) throws IOException {
        return OpenXmlUtils.readZipEntryInternal(zis);
    }

    private static byte[] readZipEntryInternal(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] block = new byte[8192];
        while (is.available() > 0) {
            int length = is.read(block);
            if (length <= 0) continue;
            bos.write(block, 0, length);
        }
        return bos.toByteArray();
    }

    public static byte[] convertDocumentToByteArray(Document doc) throws IonicException {
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bos);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IonicException(80011, (Throwable)e);
        }
        return bos.toByteArray();
    }
}

