/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.data;

import com.ionic.sdk.agent.cipher.file.family.openxml.OpenXmlUtils;
import com.ionic.sdk.agent.cipher.file.family.openxml.data.OpenXmlZipEntry;
import com.ionic.sdk.error.IonicException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;

public class OpenXmlZip {
    private static final Logger LOGGER = Logger.getLogger(OpenXmlZip.class.getName());
    private final ZipInputStream zipInputStream;
    private ZipOutputStream zipOutputStream = null;
    private HashMap<String, Document> modifiedXmlDocs;
    private ArrayList<OpenXmlZipEntry> newEntries;

    public ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    public OpenXmlZip(ZipInputStream zipInputStream) {
        this.zipInputStream = zipInputStream;
        this.modifiedXmlDocs = new HashMap();
        this.newEntries = new ArrayList();
    }

    public final void addModifiedXmlFile(String entryName, Document updatedXML) {
        this.modifiedXmlDocs.put(entryName, updatedXML);
    }

    public final void addNewEntry(OpenXmlZipEntry zipEntry) {
        this.newEntries.add(zipEntry);
    }

    public ZipOutputStream openZipFile(File outputFile) throws IOException {
        LOGGER.fine(String.format("output = %s", outputFile.getName()));
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        return this.zipOutputStream;
    }

    public ZipOutputStream openZipFile(OutputStream outputStream) throws IOException {
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
        return this.zipOutputStream;
    }

    public void writeZipFile() throws IOException, IonicException {
        LOGGER.fine("Writing the file.");
        byte[] block = new byte[8192];
        ZipEntry entry = null;
        while (null != (entry = this.zipInputStream.getNextEntry())) {
            LOGGER.fine(String.format("Entry = %s", entry.getName()));
            ZipEntry entryCopy = new ZipEntry(entry);
            entryCopy.setCompressedSize(-1L);
            Document doc = this.modifiedXmlDocs.get(entry.getName());
            if (doc != null) {
                byte[] docAsBytes = OpenXmlUtils.convertDocumentToByteArray(doc);
                entryCopy.setSize(docAsBytes.length);
                entryCopy.setTime(System.currentTimeMillis());
                this.zipOutputStream.putNextEntry(entryCopy);
                this.zipOutputStream.write(docAsBytes);
                this.zipOutputStream.closeEntry();
                continue;
            }
            this.zipOutputStream.putNextEntry(entryCopy);
            while (this.zipInputStream.available() > 0) {
                int length = this.zipInputStream.read(block);
                if (length <= 0) continue;
                this.zipOutputStream.write(block, 0, length);
            }
            this.zipOutputStream.closeEntry();
        }
        for (OpenXmlZipEntry oxEntry : this.newEntries) {
            oxEntry.addEntryToOpenXmlZip(this);
        }
    }

    public void closeZipFile() throws IOException {
        LOGGER.fine("Closing the file.");
        this.zipOutputStream.finish();
        this.zipOutputStream.flush();
        this.zipOutputStream.close();
        this.zipOutputStream = null;
    }
}

