/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.data;

import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericOutput;
import com.ionic.sdk.agent.cipher.file.family.openxml.data.OpenXmlZip;
import com.ionic.sdk.error.IonicException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class OpenXmlZipEntry {
    private ZipEntry entry;
    private InputStream inputStream;
    private GenericOutput encryptor;

    public OpenXmlZipEntry(ZipFile zip, String entryToCopy) throws IOException {
        ZipEntry content = zip.getEntry(entryToCopy);
        if (content != null) {
            this.entry = new ZipEntry(content);
            this.entry.setCompressedSize(-1L);
            this.inputStream = zip.getInputStream(content);
        }
    }

    public OpenXmlZipEntry(File inputFile) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(inputFile);
        this.inputStream = new BufferedInputStream(fis);
        this.entry = new ZipEntry(inputFile.getName());
        this.entry.setTime(inputFile.lastModified());
        this.entry.setSize(inputFile.length());
    }

    public OpenXmlZipEntry(InputStream inputStream, String filename) {
        this.inputStream = inputStream;
        this.entry = new ZipEntry(filename);
        this.entry.setTime(System.currentTimeMillis());
    }

    public OpenXmlZipEntry(InputStream inputStream, String filename, long size) {
        this.inputStream = inputStream;
        this.entry = new ZipEntry(filename);
        this.entry.setTime(System.currentTimeMillis());
        this.entry.setSize(size);
    }

    public final void setEncryption(GenericOutput encryptor) {
        this.encryptor = encryptor;
    }

    final void addEntryToOpenXmlZip(OpenXmlZip openXmlZip) throws IOException, IonicException {
        ZipOutputStream zos = openXmlZip.getZipOutputStream();
        if (this.entry != null && this.inputStream != null) {
            zos.putNextEntry(this.entry);
            if (this.encryptor == null) {
                byte[] block = new byte[8192];
                while (this.inputStream.available() > 0) {
                    int length = this.inputStream.read(block);
                    if (length <= 0) continue;
                    zos.write(block, 0, length);
                }
            } else {
                ReadableByteChannel inputChannel = Channels.newChannel(this.inputStream);
                ByteBuffer bufferPlainText = this.encryptor.getPlainText();
                while (this.inputStream.available() > 0) {
                    int length = inputChannel.read(bufferPlainText);
                    if (length <= 0) continue;
                    bufferPlainText.limit(bufferPlainText.position());
                    bufferPlainText.position(0);
                    this.encryptor.write(bufferPlainText);
                }
                this.encryptor.doFinal();
            }
            zos.closeEntry();
        }
    }
}

