/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.input;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericInput;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXmlBodyInput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@InternalUseOnly
final class OpenXml10BodyInput
implements OpenXmlBodyInput {
    private final FileCryptoFileInfo fileInfo;
    private final FileCryptoDecryptAttributes decryptAttributes;
    private final GenericInput genericInput;

    OpenXml10BodyInput(InputStream sourceStream, KeyServices agent, FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes attributes) {
        this.fileInfo = fileInfo;
        this.decryptAttributes = attributes;
        this.genericInput = new GenericInput(new BufferedInputStream(sourceStream), 10000016L, agent);
    }

    @Override
    public void init() throws IOException, IonicException {
        try {
            this.genericInput.init(this.fileInfo, this.decryptAttributes);
        }
        finally {
            if (this.fileInfo.getCipherFamily() == CipherFamily.FAMILY_GENERIC) {
                this.fileInfo.setCipherFamily(CipherFamily.FAMILY_OPENXML);
                this.fileInfo.setCipherVersion("1.0");
                this.decryptAttributes.setFamily(CipherFamily.FAMILY_OPENXML);
                this.decryptAttributes.setVersion("1.0");
            }
        }
    }

    @Override
    public ByteBuffer read() throws IOException, IonicException {
        return this.genericInput.read();
    }

    @Override
    public int available() throws IOException {
        return this.genericInput.available();
    }

    @Override
    public void doFinal() throws IOException, IonicException {
        this.genericInput.doFinal();
    }
}

