/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.input;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericInput;
import com.ionic.sdk.agent.cipher.file.family.openxml.OpenXmlUtils;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXmlBodyInput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.json.JsonObject;

@InternalUseOnly
final class OpenXml11BodyInput
implements OpenXmlBodyInput {
    private final FileCryptoFileInfo fileInfo;
    private final FileCryptoDecryptAttributes decryptAttributes;
    private final GenericInput genericInput;
    private final ZipInputStream inputZipStream;
    private boolean foundPayload;

    public static boolean getFileInfo(InputStream sourceStream, FileCryptoFileInfo fileInfo) throws IonicException {
        JsonObject ionicInfo = null;
        try {
            ZipInputStream scanZipStream = new ZipInputStream(sourceStream);
            ZipEntry zipEntry = null;
            while (null != (zipEntry = scanZipStream.getNextEntry())) {
                if (!"ionic/fileinfo.ion".equals(zipEntry.getName())) continue;
                byte[] jsonFileInfoBytes = OpenXmlUtils.readZipEntry(scanZipStream);
                ionicInfo = JsonIO.readObject(jsonFileInfoBytes);
            }
        }
        catch (IOException e) {
            throw new IonicException(80016, (Throwable)e);
        }
        if (ionicInfo != null) {
            OpenXml11BodyInput.parseFileInfoFromJson(ionicInfo, fileInfo);
            return true;
        }
        try {
            try {
                FileInputStream fs = (FileInputStream)sourceStream;
                fs.getChannel().position(0L);
            }
            catch (ClassCastException e) {
                sourceStream.reset();
            }
        }
        catch (IOException e) {
            throw new IonicException(80016, (Throwable)e);
        }
        return false;
    }

    private static void parseFileInfoFromJson(JsonObject ionicInfo, FileCryptoFileInfo fileInfo) throws IonicException {
        String family = Value.defaultOnEmpty(JsonSource.getString(ionicInfo, "family"), "openxml");
        SdkData.checkTrue("openxml".equals(family), 80017);
        String version = JsonSource.getString(ionicInfo, "version");
        SdkData.checkTrue(!Value.isEmpty(version), 80004);
        String tag = JsonSource.getString(ionicInfo, "tag");
        String server = JsonSource.getString(ionicInfo, "server");
        fileInfo.setEncrypted(true);
        fileInfo.setCipherFamily(CipherFamily.FAMILY_OPENXML);
        fileInfo.setCipherVersion(version);
        fileInfo.setKeyId(tag);
        fileInfo.setServer(server);
    }

    OpenXml11BodyInput(InputStream sourceStream, KeyServices agent, FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes attributes) throws IonicException {
        this.fileInfo = fileInfo;
        this.decryptAttributes = attributes;
        this.foundPayload = false;
        try {
            this.inputZipStream = new ZipInputStream(new BufferedInputStream(sourceStream));
            ZipEntry zipEntry = null;
            while (null != (zipEntry = this.inputZipStream.getNextEntry())) {
                if (!"ionic/embed.ion".equals(zipEntry.getName())) continue;
                this.foundPayload = true;
                break;
            }
        }
        catch (IOException e) {
            throw new IonicException(80016, (Throwable)e);
        }
        this.genericInput = new GenericInput(this.inputZipStream, 10000016L, agent);
    }

    public boolean hasValidPayloadStream() {
        return this.foundPayload;
    }

    @Override
    public void init() throws IOException, IonicException {
        try {
            this.genericInput.init(this.fileInfo, this.decryptAttributes);
        }
        finally {
            if (this.fileInfo.getCipherFamily() == CipherFamily.FAMILY_GENERIC) {
                this.fileInfo.setCipherFamily(CipherFamily.FAMILY_OPENXML);
                this.fileInfo.setCipherVersion("1.1");
                this.decryptAttributes.setFamily(CipherFamily.FAMILY_OPENXML);
                this.decryptAttributes.setVersion("1.1");
            }
        }
    }

    @Override
    public ByteBuffer read() throws IOException, IonicException {
        return this.genericInput.read();
    }

    @Override
    public int available() throws IOException {
        return this.genericInput.available();
    }

    @Override
    public void doFinal() throws IOException, IonicException {
        this.genericInput.doFinal();
        this.inputZipStream.close();
    }
}

