/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.input;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.openxml.OpenXmlUtils;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXml10BodyInput;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXml11BodyInput;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXmlBodyInput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.datastructures.Tuple;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

@InternalUseOnly
public final class OpenXmlInput {
    private final InputStream sourceStream;
    private final KeyServices agent;
    private OpenXmlBodyInput bodyInput;

    public OpenXmlInput(InputStream inputStream, KeyServices agent) {
        this.sourceStream = inputStream;
        this.agent = agent;
    }

    public static void getFileInfo(InputStream sourceStream, FileCryptoFileInfo fileInfo) throws IonicException {
        String version = OpenXmlInput.determinePossibleEncryptionVersion(sourceStream);
        if ("1.0".equals(version)) {
            throw new IonicException(80012);
        }
        if ("1.1".equals(version)) {
            Tuple<FileType, byte[]> typeAndProps = OpenXmlUtils.doFirstPassThrough(sourceStream, false);
            if (typeAndProps.first() == FileType.FILETYPE_UNKNOWN) {
                throw new IonicException(80012);
            }
            if (OpenXml11BodyInput.getFileInfo(sourceStream, fileInfo)) {
                return;
            }
            OpenXml11BodyInput bodyInput = new OpenXml11BodyInput(sourceStream, null, fileInfo, new FileCryptoDecryptAttributes());
            if (!bodyInput.hasValidPayloadStream()) {
                fileInfo.setEncrypted(false);
                fileInfo.setCipherFamily(CipherFamily.FAMILY_OPENXML);
                fileInfo.setCipherVersion("1.1");
                return;
            }
            try {
                bodyInput.init();
            }
            catch (IOException e) {
                throw new IonicException(80012);
            }
        } else {
            throw new IonicException(80012);
        }
    }

    private static String determinePossibleEncryptionVersion(InputStream sourceStream) throws IonicException {
        byte[] firstFourBytes = new byte["PK\u0003\u0004".length()];
        try {
            int readLen = sourceStream.read(firstFourBytes);
            if (readLen != firstFourBytes.length) {
                throw new IonicException(80007);
            }
            try {
                FileInputStream fs = (FileInputStream)sourceStream;
                fs.getChannel().position(0L);
            }
            catch (ClassCastException e) {
                sourceStream.reset();
            }
        }
        catch (IOException e) {
            throw new IonicException(80009);
        }
        if (firstFourBytes[0] == 123) {
            return "1.0";
        }
        if (Arrays.equals(firstFourBytes, Transcoder.utf8().decode("PK\u0003\u0004"))) {
            return "1.1";
        }
        throw new IonicException(80019);
    }

    public void init(FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes decryptAttributes) throws IonicException {
        String version = OpenXmlInput.determinePossibleEncryptionVersion(this.sourceStream);
        if ("1.0".equals(version)) {
            this.bodyInput = new OpenXml10BodyInput(this.sourceStream, this.agent, fileInfo, decryptAttributes);
        } else if ("1.1".equals(version)) {
            this.bodyInput = new OpenXml11BodyInput(this.sourceStream, this.agent, fileInfo, decryptAttributes);
        } else {
            throw new IonicException(80012);
        }
        try {
            this.bodyInput.init();
        }
        catch (IOException e) {
            throw new IonicException(80012);
        }
    }

    public int available() throws IOException {
        return this.bodyInput.available();
    }

    public ByteBuffer read() throws IOException, IonicException {
        if (this.bodyInput == null) {
            throw new IonicException(80012);
        }
        return this.bodyInput.read();
    }

    public void doFinal() throws IonicException {
        try {
            this.bodyInput.doFinal();
        }
        catch (IOException e) {
            throw new IonicException(80023);
        }
    }
}

