/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.input;

import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.family.openxml.data.OpenXmlZip;
import com.ionic.sdk.agent.cipher.file.family.openxml.input.OpenXmlPortionMarkNode;
import com.ionic.sdk.agent.request.getkey.GetKeysRequest;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InternalUseOnly
public final class OpenXmlPortionMarkInput {
    private Document xmlDocument = null;
    private ArrayList<OpenXmlPortionMarkNode> foundNodes = null;
    private KeyServices agent = null;
    private FileCryptoDecryptAttributes attributes;
    private static final String DOCX_BODY_LABEL = "w:body";
    private static final String DOCX_P_LABEL = "w:p";
    private static final String DOCX_R_LABEL = "w:r";
    private static final String DOCX_RSI_LABEL = "w:rsidRPr";
    private static final String DOCX_RPR_LABEL = "w:rPr";
    private static final String DOCX_HIGHLIGHT_LABEL = "w:highlight";
    private static final String DOCX_VAL_LABEL = "w:val";
    private static final String DOCX_T_LABEL = "w:t";
    private static final String COLOR_GREEN = "green";
    private static final String COLOR_BLUE = "blue";
    private static final String COLOR_RED = "red";
    private static final String COLOR_DARKYELLOW = "darkYellow";
    private static final String CLASS_RESTRICTED = "Restricted";
    private static final String CLASS_CONFIDENTIAL = "Confidential";
    private static final String CLASS_TOPSECRET = "Top Secret";
    private static final String CLASS_SECRET = "Secret";
    private static final int CIPHER_BLOCK_SEPARATOR = 124;

    public OpenXmlPortionMarkInput(KeyServices agent, FileCryptoDecryptAttributes attributes) {
        this.agent = agent;
        this.attributes = attributes;
    }

    public boolean findPortionMarkedSections(InputStream inputStream) {
        try {
            ZipInputStream scanZipStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = null;
            while (null != (zipEntry = scanZipStream.getNextEntry())) {
                if (!"word/document.xml".equals(zipEntry.getName())) continue;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.xmlDocument = builder.parse(scanZipStream);
                this.xmlDocument.getDocumentElement().normalize();
                break;
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        if (null == this.xmlDocument) {
            return false;
        }
        NodeList nList = this.xmlDocument.getElementsByTagName(DOCX_BODY_LABEL);
        if (nList.getLength() == 0) {
            return false;
        }
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            ArrayList<OpenXmlPortionMarkNode> found = OpenXmlPortionMarkInput.processDocxPortions(nNode);
            if (this.foundNodes != null) {
                this.foundNodes.addAll(found);
                continue;
            }
            this.foundNodes = found;
        }
        return this.foundNodes != null && !this.foundNodes.isEmpty();
    }

    public boolean decryptPortionMarkedSections(InputStream inputStream, OutputStream outputStream) throws IonicException {
        boolean decryptedAny = false;
        GetKeysResponse getKeyResponse = this.getKeys();
        if (getKeyResponse != null) {
            AesCtrCipher cipher = new AesCtrCipher();
            for (OpenXmlPortionMarkNode node : this.foundNodes) {
                String keyId;
                GetKeysResponse.Key foundKey;
                String nodeText = node.getText();
                int endPos = nodeText.indexOf(124);
                if (endPos == -1 || (foundKey = getKeyResponse.getKey(keyId = nodeText.substring(0, endPos))) == null) continue;
                cipher.setKey(foundKey.getKey());
                String encryptedText = nodeText.substring(endPos + 1);
                String plainText = cipher.decryptBase64ToString(encryptedText);
                node.getNode().setNodeValue(plainText);
                decryptedAny = true;
            }
        }
        if (decryptedAny) {
            try {
                ZipInputStream zipStream = new ZipInputStream(inputStream);
                OpenXmlZip zipOut = new OpenXmlZip(zipStream);
                zipOut.addModifiedXmlFile("word/document.xml", this.xmlDocument);
                zipOut.openZipFile(outputStream);
                zipOut.writeZipFile();
                zipOut.closeZipFile();
            }
            catch (IOException e) {
                throw new IonicException(80014, (Throwable)e);
            }
        }
        return decryptedAny;
    }

    private GetKeysResponse getKeys() throws IonicException {
        HashSet<String> keysRequested = new HashSet<String>();
        GetKeysRequest getKeysRequest = new GetKeysRequest();
        getKeysRequest.setMetadata(this.attributes.getMetadata());
        for (OpenXmlPortionMarkNode node : this.foundNodes) {
            String keyId;
            String nodeText = node.getText();
            int endPos = nodeText.indexOf(124);
            if (endPos == -1 || keysRequested.contains(keyId = nodeText.substring(0, endPos))) continue;
            getKeysRequest.add(keyId);
            keysRequested.add(keyId);
        }
        return this.agent.getKeys(getKeysRequest);
    }

    private static ArrayList<OpenXmlPortionMarkNode> processDocxPortions(Node xmlNode) {
        ArrayList<OpenXmlPortionMarkNode> foundNodes = new ArrayList<OpenXmlPortionMarkNode>();
        NodeList nList = xmlNode.getChildNodes();
        for (int index = 0; index < nList.getLength(); ++index) {
            Node item = nList.item(index);
            if (item.getNodeType() != 1 || !item.hasAttributes() || !DOCX_P_LABEL.equals(item.getNodeName())) continue;
            NodeList nPList = item.getChildNodes();
            for (int indexP = 0; indexP < nPList.getLength(); ++indexP) {
                OpenXmlPortionMarkNode foundNode;
                Element eElement;
                Node itemP = nPList.item(indexP);
                if (itemP.getNodeType() != 1 || !itemP.hasAttributes() || !DOCX_R_LABEL.equals(itemP.getNodeName()) || (eElement = (Element)itemP).getAttribute(DOCX_RSI_LABEL).length() <= 0 || (foundNode = OpenXmlPortionMarkInput.processDocxPortionsRNode(eElement)) == null) continue;
                foundNodes.add(foundNode);
            }
        }
        return foundNodes;
    }

    private static OpenXmlPortionMarkNode processDocxPortionsRNode(Element eElement) {
        String color = null;
        String text = null;
        Node node = null;
        NodeList nList = eElement.getChildNodes();
        for (int index = 0; index < nList.getLength(); ++index) {
            Node item = nList.item(index);
            if (item.getNodeType() == 1 && DOCX_RPR_LABEL.equals(item.getNodeName())) {
                NodeList rprList = item.getChildNodes();
                for (int rprIndex = 0; rprIndex < rprList.getLength(); ++rprIndex) {
                    Node rprItem = rprList.item(rprIndex);
                    if (rprItem.getNodeType() != 1 || !DOCX_HIGHLIGHT_LABEL.equals(rprItem.getNodeName())) continue;
                    Element higlightElem = (Element)rprItem;
                    color = higlightElem.getAttribute(DOCX_VAL_LABEL);
                }
                continue;
            }
            if (item.getNodeType() != 1 || !DOCX_T_LABEL.equals(item.getNodeName())) continue;
            NodeList tList = item.getChildNodes();
            for (int tIndex = 0; tIndex < tList.getLength(); ++tIndex) {
                Node tItem = tList.item(tIndex);
                if (tItem.getNodeType() != 3) continue;
                text = tItem.getNodeValue();
                node = tItem;
            }
        }
        if (color == null || text == null || node == null || OpenXmlPortionMarkInput.getHilightColorConfidentiality(color) == null) {
            return null;
        }
        int endPos = text.indexOf(124);
        if (endPos == -1) {
            return null;
        }
        return new OpenXmlPortionMarkNode(color, text, node);
    }

    private static String getHilightColorConfidentiality(String color) {
        if (color.equals(COLOR_GREEN)) {
            return CLASS_RESTRICTED;
        }
        if (color.equals(COLOR_BLUE)) {
            return CLASS_CONFIDENTIAL;
        }
        if (color.equals(COLOR_DARKYELLOW)) {
            return CLASS_SECRET;
        }
        if (color.equals(COLOR_RED)) {
            return CLASS_TOPSECRET;
        }
        return null;
    }
}

