/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.output;

import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericOutput;
import com.ionic.sdk.agent.cipher.file.family.openxml.output.OpenXmlBodyOutput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

@InternalUseOnly
final class OpenXml10BodyOutput
implements OpenXmlBodyOutput {
    private final OutputStream targetStream;
    private final FileCryptoEncryptAttributes encryptAttributes;
    private final GenericOutput genericOutput;

    OpenXml10BodyOutput(OutputStream targetStream, KeyServices agent, FileCryptoEncryptAttributes encryptAttributes) {
        this.targetStream = targetStream;
        this.encryptAttributes = encryptAttributes;
        this.genericOutput = new GenericOutput(targetStream, 8192L, agent);
    }

    @Override
    public void init() throws IOException, IonicException {
        FileCryptoEncryptAttributes genericEncryptAttributes = new FileCryptoEncryptAttributes("1.1", this.encryptAttributes.getKeyAttributes(), this.encryptAttributes.getMutableKeyAttributes());
        genericEncryptAttributes.setMetadata(this.encryptAttributes.getMetadata());
        this.genericOutput.init(genericEncryptAttributes);
        this.encryptAttributes.setKeyResponse(genericEncryptAttributes.getKeyResponse());
    }

    @Override
    public void doEncryption(InputStream plainText) throws IOException, IonicException {
        ReadableByteChannel plainChannel = Channels.newChannel(plainText);
        ByteBuffer bufferPlainText = this.genericOutput.getPlainText();
        while (plainText.available() > 0) {
            bufferPlainText.clear();
            int count = plainChannel.read(bufferPlainText);
            bufferPlainText.position(0);
            bufferPlainText.limit(count);
            this.genericOutput.write(bufferPlainText);
        }
        this.genericOutput.doFinal();
        this.targetStream.flush();
    }
}

