/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.output;

import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericOutput;
import com.ionic.sdk.agent.cipher.file.family.openxml.OpenXmlUtils;
import com.ionic.sdk.agent.cipher.file.family.openxml.data.OpenXmlZip;
import com.ionic.sdk.agent.cipher.file.family.openxml.data.OpenXmlZipEntry;
import com.ionic.sdk.agent.cipher.file.family.openxml.output.OpenXmlBodyOutput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.datastructures.Tuple;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonTarget;
import com.ionic.sdk.key.KeyServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.ZipInputStream;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.w3c.dom.Document;

@InternalUseOnly
final class OpenXml11BodyOutput
implements OpenXmlBodyOutput {
    private final OutputStream targetStream;
    private final KeyServices agent;
    private final FileCryptoCoverPageServicesInterface coverPageServices;
    private final FileCryptoEncryptAttributes encryptAttributes;
    private GenericOutput genericOutput = null;
    private OpenXmlZip outputZip = null;
    private final FileType fileType;
    private final byte[] customPropFile;
    private Document contents = null;
    private Document relationships = null;
    private final File tempFile;
    private FileOutputStream fileOutputStream = null;
    private ByteArrayOutputStream byteOutputStream = null;
    private static final String JSON_FIELD_FAMILY = "family";
    private static final String JSON_FIELD_VERSION = "version";
    private static final String JSON_FIELD_SERVER = "server";
    private static final String JSON_FIELD_TAG = "tag";
    private static final String JSON_FIELD_PORTION_MARKING = "portionMarkingEnabled";

    OpenXml11BodyOutput(OutputStream targetStream, KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices, FileCryptoEncryptAttributes encryptAttributes, FileType fileType, byte[] customPropFile, File tempFile) {
        this.targetStream = targetStream;
        this.agent = agent;
        this.coverPageServices = coverPageServices;
        this.encryptAttributes = encryptAttributes;
        this.fileType = fileType;
        this.customPropFile = customPropFile;
        this.tempFile = tempFile;
    }

    @Override
    public void init() throws IOException, IonicException {
        ByteArrayInputStream coverpageStream = new ByteArrayInputStream(this.coverPageServices.getCoverPage(this.fileType));
        Tuple<Document, Document> docs = OpenXmlUtils.getContentsAndRelationsFilesFromStream(coverpageStream);
        this.contents = docs.first();
        this.relationships = docs.second();
        coverpageStream.reset();
        OpenXmlUtils.registerOpenXmlContentType(this.contents, "ion", "application/octet-stream");
        if (this.customPropFile != null) {
            OpenXmlUtils.registerOpenXmlContentTypeOverride(this.contents, "/docProps/custom.xml", "application/vnd.openxmlformats-officedocument.custom-properties+xml");
        }
        OpenXmlUtils.registerOpenXmlRelationship(this.relationships, "http://ionic.com/relationship/embed/protectedDocument", "ionic/embed.ion", "rIdIonic");
        OpenXmlUtils.registerOpenXmlRelationship(this.relationships, "http://ionic.com/relationship/embed/protectedDocumentFileInfo", "ionic/fileinfo.ion", "rIdIonicFileInfo");
        if (this.customPropFile != null) {
            OpenXmlUtils.registerOpenXmlRelationship(this.relationships, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties", "docProps/custom.xml", "rIdCustomXml");
        }
        this.outputZip = new OpenXmlZip(new ZipInputStream(coverpageStream));
        this.outputZip.addModifiedXmlFile("[Content_Types].xml", this.contents);
        this.outputZip.addModifiedXmlFile("_rels/.rels", this.relationships);
        OutputStream tempOutput = null;
        if (this.tempFile != null) {
            this.fileOutputStream = new FileOutputStream(this.tempFile);
            tempOutput = this.fileOutputStream;
        } else {
            tempOutput = this.byteOutputStream = new ByteArrayOutputStream();
        }
        FileCryptoEncryptAttributes genericEncryptAttributes = new FileCryptoEncryptAttributes("1.2", this.encryptAttributes.getKeyAttributes(), this.encryptAttributes.getMutableKeyAttributes());
        genericEncryptAttributes.setMetadata(this.encryptAttributes.getMetadata());
        this.genericOutput = new GenericOutput(tempOutput, 10000000L, this.agent);
        this.genericOutput.init(genericEncryptAttributes);
        this.encryptAttributes.setKeyResponse(genericEncryptAttributes.getKeyResponse());
    }

    @Override
    public void doEncryption(InputStream plainText) throws IOException, IonicException {
        long fileSize;
        ReadableByteChannel plainChannel = Channels.newChannel(plainText);
        InputStream encryptedPayloadStream = null;
        ByteBuffer bufferPlainText = this.genericOutput.getPlainText();
        while (plainText.available() > 0) {
            int length = plainChannel.read(bufferPlainText);
            if (length <= 0) continue;
            bufferPlainText.limit(bufferPlainText.position());
            bufferPlainText.position(0);
            this.genericOutput.write(bufferPlainText);
        }
        this.genericOutput.doFinal();
        byte[] signature = this.genericOutput.getSignature();
        if (this.fileOutputStream != null) {
            if (signature != null) {
                this.fileOutputStream.getChannel().position(this.genericOutput.getHeaderLength());
                this.fileOutputStream.write(signature);
            }
            this.fileOutputStream.close();
            encryptedPayloadStream = new FileInputStream(this.tempFile);
            fileSize = this.tempFile.length();
        } else {
            byte[] bytes = this.byteOutputStream.toByteArray();
            if (signature != null) {
                System.arraycopy(signature, 0, bytes, this.genericOutput.getHeaderLength(), signature.length);
            }
            encryptedPayloadStream = new ByteArrayInputStream(bytes);
            fileSize = bytes.length;
        }
        OpenXmlZipEntry payloadEntry = new OpenXmlZipEntry(encryptedPayloadStream, "ionic/embed.ion", fileSize);
        this.outputZip.addNewEntry(payloadEntry);
        if (this.customPropFile != null) {
            OpenXmlZipEntry propEntry = new OpenXmlZipEntry(new ByteArrayInputStream(this.customPropFile), "docProps/custom.xml", this.customPropFile.length);
            this.outputZip.addNewEntry(propEntry);
        }
        byte[] jsonInfo = Transcoder.utf8().decode(this.createJsonInfo());
        OpenXmlZipEntry infoEntry = new OpenXmlZipEntry(new ByteArrayInputStream(jsonInfo), "ionic/fileinfo.ion", jsonInfo.length);
        this.outputZip.addNewEntry(infoEntry);
        this.outputZip.openZipFile(this.targetStream);
        this.outputZip.writeZipFile();
        this.outputZip.closeZipFile();
        encryptedPayloadStream.close();
    }

    private String createJsonInfo() {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonTarget.addNotNull(objectBuilder, JSON_FIELD_FAMILY, "openxml");
        JsonTarget.addNotNull(objectBuilder, JSON_FIELD_VERSION, "1.1");
        JsonTarget.addNotNull(objectBuilder, JSON_FIELD_SERVER, this.agent.getActiveProfile().getServer());
        JsonTarget.addNotNull(objectBuilder, JSON_FIELD_TAG, this.encryptAttributes.getKeyId());
        JsonTarget.add(objectBuilder, JSON_FIELD_PORTION_MARKING, 0L);
        return JsonIO.write(objectBuilder.build(), true);
    }
}

