/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.openxml.output;

import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.openxml.output.OpenXml10BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.openxml.output.OpenXml11BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.openxml.output.OpenXmlBodyOutput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@InternalUseOnly
public final class OpenXmlOutput {
    private final OutputStream targetStream;
    private final KeyServices agent;
    private OpenXmlBodyOutput bodyOutput;
    private FileCryptoCoverPageServicesInterface coverpage;
    private final FileType fileType;
    private final byte[] customPropFile;
    private final File tempFile;

    public OpenXmlOutput(OutputStream outputStream, KeyServices agent, FileCryptoCoverPageServicesInterface coverpage, FileType fileType, byte[] customPropFile, File tempFile) {
        this.targetStream = outputStream;
        this.agent = agent;
        this.coverpage = coverpage;
        this.fileType = fileType;
        this.customPropFile = (byte[])(customPropFile != null ? (byte[])customPropFile.clone() : null);
        this.tempFile = tempFile;
    }

    public void init(FileCryptoEncryptAttributes encryptAttributes) throws IonicException, IOException {
        encryptAttributes.setFamily(CipherFamily.FAMILY_OPENXML);
        encryptAttributes.setVersion(Value.defaultOnEmpty(encryptAttributes.getVersion(), "1.1"));
        String version = encryptAttributes.getVersion();
        SdkData.checkTrue(!Value.isEmpty(version), 80004);
        if ("1.0".equals(version)) {
            this.bodyOutput = new OpenXml10BodyOutput(this.targetStream, this.agent, encryptAttributes);
        } else if ("1.1".equals(version)) {
            this.bodyOutput = new OpenXml11BodyOutput(this.targetStream, this.agent, this.coverpage, encryptAttributes, this.fileType, this.customPropFile, this.tempFile);
        } else {
            throw new IonicException(80012);
        }
        this.bodyOutput.init();
    }

    public void doEncryption(InputStream plainText) throws IOException, IonicException {
        this.bodyOutput.doEncryption(plainText);
    }
}

