/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.body;

import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfString;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.core.annotation.InternalUseOnly;

@InternalUseOnly
public final class PdfBodyObject {
    private final Xref xref;
    private final PdfObject value;
    private final int offsetStream;
    private final String prologue;

    public Xref getXref() {
        return this.xref;
    }

    public PdfObject getValue() {
        return this.value;
    }

    public PdfDictionary getDictionary() {
        return this.value instanceof PdfDictionary ? (PdfDictionary)this.value : null;
    }

    public boolean hasStream() {
        PdfDictionary dictionary = this.value instanceof PdfDictionary ? (PdfDictionary)this.value : null;
        return dictionary != null && dictionary.getStringValue("/Length") != null;
    }

    public int getOffsetStream() {
        return this.offsetStream;
    }

    public String getPrologue() {
        return this.prologue;
    }

    public PdfBodyObject(Xref xref, PdfObject value, int offsetStream, String prologue) {
        this.xref = xref;
        this.value = value;
        this.offsetStream = offsetStream;
        this.prologue = prologue;
    }

    public String getStringValue() {
        String stringValue;
        if (this.value == null) {
            stringValue = null;
        } else if (this.value instanceof PdfString) {
            stringValue = ((PdfString)this.value).getValue();
        } else {
            throw new IllegalArgumentException(this.value.getClass().getName());
        }
        return stringValue;
    }

    public String getDictionaryValue(String key) {
        return this.value instanceof PdfDictionary ? ((PdfDictionary)this.value).getStringValue(key) : null;
    }
}

