/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.data;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDocument;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfStreamReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;

@InternalUseOnly
public final class IonicPdfDocument {
    private final PdfDocument pdfDocument;

    public IonicPdfDocument(SeekableByteChannel channel, int length) {
        this.pdfDocument = new PdfDocument(channel, length);
    }

    public void initialize() throws IOException, IonicException {
        this.pdfDocument.initialize();
    }

    public XrefTable getXrefTable() {
        return this.pdfDocument.getXrefTable();
    }

    public Xref getXrefIonic() throws IOException, IonicException {
        PdfObjectReader pdfObjectReader;
        PdfBodyObject pdfInfo;
        String referencePayloadIndirect;
        Xref xrefIonicIndirect;
        Xref xrefIonic = null;
        XrefTable xrefTable = this.pdfDocument.getXrefTable();
        PdfDictionary trailerDictionary = xrefTable.getTrailerDictionary();
        SdkData.checkTrue(trailerDictionary != null, 80011);
        String referenceInfo = trailerDictionary.getStringValue("/Info");
        String referenceEncrypt = trailerDictionary.getStringValue("/Encrypt");
        Xref xrefInfoIndirect = xrefTable.getXrefIndirect(referenceInfo);
        if (xrefInfoIndirect != null && xrefInfoIndirect.isInUse() && referenceEncrypt == null && (xrefIonicIndirect = xrefTable.getXrefIndirect(referencePayloadIndirect = (pdfInfo = (pdfObjectReader = this.pdfDocument.getPdfObjectReader(xrefInfoIndirect.getObjectNumber())).readPartial()).getDictionaryValue("/IonicPayload"))) != null && xrefIonicIndirect.isInUse()) {
            xrefIonic = (Xref)xrefTable.get(xrefIonicIndirect.getObjectNumber());
        }
        return xrefIonic;
    }

    public PdfObjectReader getPdfObjectReader(int ordinal) throws IOException, IonicException {
        return this.pdfDocument.getPdfObjectReader(ordinal);
    }

    public byte[] getPayloadIonic(Xref xrefIonic) throws IOException, IonicException {
        SdkData.checkTrue(xrefIonic != null, 80021);
        PdfObjectReader pdfObjectReader = this.pdfDocument.getPdfObjectReader(xrefIonic.getObjectNumber());
        PdfBodyObject pdfObjectHeader = pdfObjectReader.readPartial();
        SdkData.checkTrue(pdfObjectHeader != null, 80021);
        PdfStreamReader pdfStreamReader = new PdfStreamReader(pdfObjectReader);
        byte[] pdfStream = pdfStreamReader.readStream(pdfObjectHeader);
        SdkData.checkTrue(pdfStream != null, 80021);
        return pdfStream;
    }
}

