/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.data;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public final class Pdf {
    public static final String XREF_FORMAT = "%010d %05d %s";
    public static final String LENGTH_FORMAT = "%010d";
    public static final String XREF_IN_USE = "n";
    public static final String REFERENCE = "R";
    public static final String CHARSET = StandardCharsets.ISO_8859_1.name();

    private Pdf() {
    }

    public static class KV {
        public static final String INFO = "/Info";
        public static final String ENCRYPT = "/Encrypt";
        public static final String PREV = "/Prev";
        public static final String IONIC_PAYLOAD = "/IonicPayload";
        public static final String LENGTH = "/Length";
        public static final String COLUMNS = "/Columns";
        public static final String DECODE_PARMS = "/DecodeParms";
        public static final String INDEX = "/Index";
        public static final String SIZE = "/Size";
        public static final String W = "/W";
        public static final String FILTER = "/Filter";
        public static final String FIRST = "/First";
        public static final String FLATE_DECODE = "/FlateDecode";
        public static final String TYPE = "/Type";
        public static final String XREF = "/XRef";
    }

    public static class Regex {
        public static final Pattern XREF_TABLE_HEADER = Pattern.compile("\\G\\s*xref\\s+");
        public static final Pattern XREF_SECTION_HEADER = Pattern.compile("\\G(\\d+)\\s(\\d+)\\s{1,3}");
        public static final Pattern XREF_ENTRY = Pattern.compile("\\G(\\d{10})\\s(\\d{5})\\s(\\w)\\s{1,2}");
        public static final Pattern OBJSTM_ENTRY = Pattern.compile("\\G(\\d+) (\\d+) ");
        public static final Pattern TRAILER_HEAD = Pattern.compile("\\G(?s)trailer\\s{1,2}");
        public static final Pattern TRAILER = Pattern.compile("(?s)trailer\\s{1,2}(<<.+?>>)\\s{1,2}");
        public static final Pattern STARTXREF = Pattern.compile("startxref\\s+(\\d+)\\s+%%EOF\\s*");
    }

    public static class Token {
        public static final String SPACER = " ";
        public static final String EOL = "\n";
        public static final String OBJ = "%d %d obj";
        public static final String ENDOBJ = "endobj\n";
        public static final String DICT = "<<";
        public static final String ENDDICT = ">>\n";
        public static final String STREAM = "stream\n";
        public static final String ENDSTREAM = "endstream\n";
        public static final String XREF = "xref\n";
        public static final String TRAILER = "trailer\n";
        public static final String STARTXREF = "startxref\n";
        public static final String EOF = "%%EOF\n";
    }
}

