/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.data;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfDictionaryReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfStreamReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.stream.StreamXrefTableReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.core.zip.Flate;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import java.util.regex.MatchResult;

@InternalUseOnly
public final class PdfDocument {
    private final SeekableByteChannel channel;
    private final int length;
    private final Collection<XrefTable> xrefTables;
    private static final int MAX_STARTXREF = 256;
    private static final int MAX_XREF_SECTION_HEADER = 16;
    private static final int SIZE_XREF = 20;

    public XrefTable getXrefTable() {
        return this.xrefTables.isEmpty() ? new XrefTable(0) : this.xrefTables.iterator().next();
    }

    public PdfDocument(SeekableByteChannel channel, int length) {
        this.channel = channel;
        this.length = length;
        this.xrefTables = new ArrayList<XrefTable>();
    }

    public void initialize() throws IOException, IonicException {
        SdkData.checkTrue(this.length > 0, 80009);
        String offsetXref = this.getStartXref((int)this.channel.size());
        while (offsetXref != null) {
            int offset = Value.toInt(offsetXref, this.length);
            SdkData.checkTrue(offset >= 0, 80011);
            SdkData.checkTrue(offset < this.length, 80011);
            XrefTable xrefTable = this.loadXrefTable(offset);
            this.xrefTables.add(xrefTable);
            PdfDictionary trailerDictionary = xrefTable.getTrailerDictionary();
            offsetXref = trailerDictionary.getStringValue("/Prev");
        }
    }

    private String getStartXref(int offsetEnd) throws IOException, IonicException {
        int offsetBegin = Math.max(0, offsetEnd - 256);
        byte[] bytes = new byte[offsetEnd - offsetBegin];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        this.channel.position(offsetBegin);
        int bytesReadStartXref = this.channel.read(byteBuffer);
        SdkData.checkTrue(bytes.length == bytesReadStartXref, 80011);
        Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(bytes), Pdf.CHARSET);
        String startxref = scanner.findWithinHorizon(Pdf.Regex.STARTXREF, 0);
        SdkData.checkTrue(startxref != null, 80011);
        return scanner.match().group(1);
    }

    private XrefTable loadXrefTable(int offset) throws IOException, IonicException {
        this.channel.position(offset);
        Scanner scanner = new Scanner((ReadableByteChannel)this.channel, Pdf.CHARSET);
        String xrefTableHeader = scanner.findWithinHorizon(Pdf.Regex.XREF_TABLE_HEADER, 256);
        if (xrefTableHeader == null) {
            Xref xref = new Xref(0, offset, 0, "n", null);
            PdfObjectReader reader = new PdfObjectReader(this.channel, xref, null);
            PdfBodyObject pdfBodyObject = reader.readPartial();
            String type = pdfBodyObject.getDictionaryValue("/Type");
            String encrypt = pdfBodyObject.getDictionaryValue("/Encrypt");
            SdkData.checkTrue("/XRef".equals(type), 80011);
            SdkData.checkTrue(null == encrypt, 80017);
            PdfStreamReader pdfStreamReader = new PdfStreamReader(reader);
            byte[] pdfStreamRaw = pdfStreamReader.readStream(pdfBodyObject);
            boolean deflated = "/FlateDecode".equals(pdfBodyObject.getDictionaryValue("/Filter"));
            byte[] pdfStream = deflated ? Flate.inflate(pdfStreamRaw) : pdfStreamRaw;
            StreamXrefTableReader xrefTableReader = new StreamXrefTableReader(pdfBodyObject);
            return xrefTableReader.read(offset, this.channel, pdfStream);
        }
        return this.parseXrefTable(offset, scanner);
    }

    private XrefTable parseXrefTable(int offset, Scanner scanner) throws IonicException {
        XrefTable xrefTable = new XrefTable(offset);
        boolean foundTrailer = false;
        while (!foundTrailer) {
            if (scanner.findWithinHorizon(Pdf.Regex.XREF_SECTION_HEADER, 16) != null) {
                MatchResult matchXrefSection = scanner.match();
                int xrefStart = Value.toInt(matchXrefSection.group(1), 0);
                int xrefCount = Value.toInt(matchXrefSection.group(2), 0);
                for (int i = xrefStart; i < xrefStart + xrefCount; ++i) {
                    String xrefText = scanner.findWithinHorizon(Pdf.Regex.XREF_ENTRY, 20);
                    SdkData.checkTrue(xrefText != null, 80011);
                    MatchResult matchXrefItem = scanner.match();
                    Xref xref = new Xref(matchXrefItem.group(), i);
                    xrefTable.put(i, xref);
                }
                continue;
            }
            if (scanner.findWithinHorizon(Pdf.Regex.TRAILER_HEAD, this.length) != null) {
                foundTrailer = true;
                PdfDictionaryReader reader = new PdfDictionaryReader(scanner);
                PdfObject pdfObject = reader.read();
                SdkData.checkTrue(pdfObject instanceof PdfDictionary, 80011);
                xrefTable.setTrailerDictionary((PdfDictionary)pdfObject);
                continue;
            }
            throw new IonicException(80011);
        }
        return xrefTable;
    }

    public PdfObjectReader getPdfObjectReader(int ordinal) throws IOException, IonicException {
        Xref xref = this.getXrefIndirectInternal(ordinal);
        XrefTable xrefTable = this.xrefTables.isEmpty() ? new XrefTable(0) : this.xrefTables.iterator().next();
        SdkData.checkTrue(xref != null, 80011);
        return new PdfObjectReader(this.channel, xref, xrefTable);
    }

    public Xref getXrefIndirect(int ordinal) {
        return this.getXrefIndirectInternal(ordinal);
    }

    private Xref getXrefIndirectInternal(int ordinal) {
        Xref xref = null;
        Iterator<XrefTable> iterator = this.xrefTables.iterator();
        while (iterator.hasNext() && xref == null) {
            XrefTable xrefTable = iterator.next();
            xref = (Xref)xrefTable.get(ordinal);
        }
        return xref;
    }
}

