/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.input;

import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoFileInfo;
import com.ionic.sdk.agent.cipher.file.family.generic.input.GenericInput;
import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.IonicPdfDocument;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.io.ByteChannelWindow;
import com.ionic.sdk.core.io.ByteQueueInputStream;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

@InternalUseOnly
public final class PdfInput {
    private final SeekableByteChannel sourceChannel;
    private final KeyServices agent;
    private PdfObjectReader pdfObjectReader;
    private ByteChannelWindow byteChannelWindow;
    private ByteQueueInputStream intermediateStream;
    private ByteBuffer cipherText;
    private GenericInput genericInput;

    public PdfInput(SeekableByteChannel sourceChannel, KeyServices agent) {
        this.sourceChannel = sourceChannel;
        this.agent = agent;
    }

    public void init(FileCryptoFileInfo fileInfo, FileCryptoDecryptAttributes decryptAttributes) throws IonicException, IOException {
        fileInfo.setCipherFamily(CipherFamily.FAMILY_UNKNOWN);
        fileInfo.setCipherVersion("");
        IonicPdfDocument ionicPdfDocument = new IonicPdfDocument(this.sourceChannel, (int)this.sourceChannel.size());
        ionicPdfDocument.initialize();
        fileInfo.setCipherFamily(CipherFamily.FAMILY_PDF);
        fileInfo.setCipherVersion("1.0");
        Xref xrefIonic = ionicPdfDocument.getXrefIonic();
        SdkData.checkTrue(xrefIonic != null, 80021);
        this.pdfObjectReader = new PdfObjectReader(this.sourceChannel, xrefIonic, ionicPdfDocument.getXrefTable());
        PdfBodyObject pdfBodyObject = this.pdfObjectReader.readPartial();
        int start = this.pdfObjectReader.readStreamInit(pdfBodyObject);
        int length = this.pdfObjectReader.readStreamLength(pdfBodyObject.getDictionaryValue("/Length"));
        SdkData.checkTrue(length > 0, 80011);
        this.byteChannelWindow = new ByteChannelWindow(this.sourceChannel, start, start + length);
        this.intermediateStream = new ByteQueueInputStream(10000);
        byte[] bytesHeader = new byte[10000];
        int bytesRead = this.byteChannelWindow.read(bytesHeader);
        this.intermediateStream.addBytes(bytesHeader, 0, bytesRead);
        fileInfo.setEncrypted(true);
        this.genericInput = new GenericInput(this.intermediateStream, length, this.agent);
        this.cipherText = this.genericInput.getCipherText();
        FileCryptoFileInfo fileInfoEmbed = new FileCryptoFileInfo();
        this.genericInput.init(fileInfoEmbed, decryptAttributes);
        fileInfo.setKeyId(fileInfoEmbed.getKeyId());
        fileInfo.setServer(fileInfoEmbed.getServer());
        decryptAttributes.setFamily(CipherFamily.FAMILY_PDF);
        decryptAttributes.setVersion("1.0");
    }

    public int available() throws IOException {
        return this.genericInput.available() + this.intermediateStream.available() + (int)this.byteChannelWindow.available();
    }

    public ByteBuffer read() throws IOException, IonicException {
        int blockSize = 10000016;
        while (this.intermediateStream.available() < 10000016 && this.byteChannelWindow.available() > 0L) {
            this.cipherText.clear();
            this.byteChannelWindow.read(this.cipherText);
            this.intermediateStream.addBytes(this.cipherText);
        }
        return this.genericInput.read();
    }

    public void doFinal() throws IonicException {
        this.genericInput.doFinal();
        this.pdfObjectReader.readStreamWrapup();
    }
}

