/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.io;

import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfArray;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfString;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.util.Scanner;
import java.util.regex.Pattern;

@InternalUseOnly
public final class PdfDictionaryReader {
    private final Scanner scanner;
    private int count;
    private static final String TOKEN_DICT_CLOSE = ">>";
    private static final String TOKEN_ARRAY_CLOSE = "]";
    private static final Pattern OBJ_DICT_OPEN = Pattern.compile("\\G(<<)(\\s{0,3}|(?=/)|(?=>>))");
    private static final Pattern OBJ_DICT_CLOSE = Pattern.compile("\\G(>>)(\\s*|(?=/)|(?=<<))");
    private static final Pattern OBJ_NAME = Pattern.compile("(?s)\\G(/[\\w\\x3a\\x2e\\x2b\\x2d\\x23\\x24\\x5c\\x7b]+)(\\s+|(?=/)|(?=<<)|(?=>>)|(?=\\[)|(?=\\()|(?=])|(?=<))");
    private static final Pattern OBJ_INDIRECT = Pattern.compile("(?s)\\G(\\d+\\s\\d+\\sR)(\\s*|(?=/)|(?=>>)|(?=]))");
    private static final Pattern OBJ_LITERAL = Pattern.compile("(?s)\\G(\\([^()]*(?:\\([^()]*\\)[^()]*)*\\))(\\s+|(?=/)|(?=>>)|(?=\\()|(?=]))");
    private static final Pattern OBJ_LITERAL_HEX = Pattern.compile("(?s)\\G(<.+?>)(\\s+|(?=/)|(?=>>)|(?=<)|(?=]))");
    private static final Pattern OBJ_ARRAY_OPEN = Pattern.compile("(?s)\\G(\\[)(\\s*)");
    private static final Pattern OBJ_ARRAY_CLOSE = Pattern.compile("(?s)\\G(])(\\s*|(?=/)|(?=>>))");
    private static final Pattern OBJ_NUMERIC = Pattern.compile("\\G(-?\\d+(\\x2e\\d+)?)(\\s+|(?=/)|(?=>>)|(?=\\[)|(?=]))");
    private static final Pattern OBJ_BOOLEAN = Pattern.compile("\\G(false|true)\\s*");

    public int getCount() {
        return this.count;
    }

    public PdfDictionaryReader(Scanner scanner) {
        this.scanner = scanner;
        this.count = 0;
    }

    public PdfObject read() throws IonicException {
        return this.readValue();
    }

    private PdfDictionary readInner(String token) throws IonicException {
        PdfDictionary dictionary = new PdfDictionary();
        SdkData.checkTrue(token != null, 80011);
        this.count += this.scanner.match().end() - this.scanner.match().start();
        String findClose = this.readInner(dictionary);
        SdkData.checkTrue(TOKEN_DICT_CLOSE.equals(findClose), 80011);
        return dictionary;
    }

    private String readInner(PdfDictionary dictionary) throws IonicException {
        String name = null;
        while (this.scanner.hasNext() && !(name = this.readName()).equals(TOKEN_DICT_CLOSE)) {
            PdfObject value = this.readValue();
            dictionary.put(name, value);
        }
        return name;
    }

    private String readName() throws IonicException {
        int horizonDictionaryClose = 32;
        String findClose = this.scanner.findWithinHorizon(OBJ_DICT_CLOSE, 32);
        String findName = findClose == null ? this.scanner.findWithinHorizon(OBJ_NAME, 0) : findClose;
        SdkData.checkTrue(findName != null, 80011);
        this.count += this.scanner.match().end() - this.scanner.match().start();
        return this.scanner.match().group(1);
    }

    private PdfObject readValue() throws IonicException {
        int horizonDictionaryOpen = 32;
        int horizonDictionaryValue = 1024;
        if (this.scanner.findWithinHorizon(OBJ_NAME, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return new PdfString(this.scanner.match().group(1));
        }
        if (this.scanner.findWithinHorizon(OBJ_INDIRECT, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return new PdfString(this.scanner.match().group(1));
        }
        if (this.scanner.findWithinHorizon(OBJ_NUMERIC, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return new PdfString(this.scanner.match().group(1));
        }
        if (this.scanner.findWithinHorizon(OBJ_BOOLEAN, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return new PdfString(this.scanner.match().group(1));
        }
        if (this.scanner.findWithinHorizon(OBJ_LITERAL, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return new PdfString(this.scanner.match().group(1));
        }
        if (this.scanner.findWithinHorizon(OBJ_DICT_OPEN, 32) != null) {
            return this.readDictionaryValue();
        }
        if (this.scanner.findWithinHorizon(OBJ_LITERAL_HEX, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return new PdfString(this.scanner.match().group(1));
        }
        if (this.scanner.findWithinHorizon(OBJ_ARRAY_OPEN, 1024) != null) {
            this.count += this.scanner.match().end() - this.scanner.match().start();
            return this.readArrayValue();
        }
        throw new IonicException(80011);
    }

    private PdfDictionary readDictionaryValue() throws IonicException {
        PdfDictionaryReader readerInner = new PdfDictionaryReader(this.scanner);
        String dictionaryOpen = this.scanner.match().group(1);
        PdfDictionary dictionaryInner = readerInner.readInner(dictionaryOpen);
        this.count += readerInner.getCount();
        return dictionaryInner;
    }

    private PdfArray readArrayValue() throws IonicException {
        PdfArray array = new PdfArray();
        this.readArrayValueInner(array);
        return array;
    }

    private PdfObject readArrayValueInner(PdfArray array) throws IonicException {
        while (this.scanner.hasNext()) {
            int horizonArrayClose = 32;
            String findClose = this.scanner.findWithinHorizon(OBJ_ARRAY_CLOSE, 32);
            if (findClose == null) {
                PdfObject findValue = this.readValue();
                SdkData.checkTrue(findValue != null, 80011);
                array.add(findValue);
                continue;
            }
            this.count += this.scanner.match().end() - this.scanner.match().start();
            break;
        }
        return array;
    }
}

