/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.io;

import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

@InternalUseOnly
public class PdfDictionaryWriter {
    private final PrintStream printStream;

    public PdfDictionaryWriter(PrintStream printStream) {
        this.printStream = printStream;
    }

    public int write(PdfDictionary dictionary, boolean formatForCompatibility) throws UnsupportedEncodingException {
        String dictionaryText = PdfDictionaryWriter.writeInternal(dictionary, formatForCompatibility);
        this.printStream.print(dictionaryText);
        return dictionaryText.length();
    }

    private static String writeInternal(PdfDictionary dictionary, boolean formatForCompatibility) throws UnsupportedEncodingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)os, false, Pdf.CHARSET);
        ps.print("<<");
        ps.print(formatForCompatibility ? "" : " ");
        Map.Entry first = dictionary.entrySet().iterator().next();
        for (Map.Entry entry : dictionary.entrySet()) {
            ps.print(first.equals(entry) ? "" : " ");
            ps.print((String)entry.getKey());
            ps.print(" ");
            PdfObject value = (PdfObject)entry.getValue();
            if (value instanceof PdfDictionary) {
                ps.print(PdfDictionaryWriter.writeInternal((PdfDictionary)value, formatForCompatibility));
                continue;
            }
            ps.print(value);
        }
        ps.print(formatForCompatibility ? "" : " ");
        ps.print(">>\n");
        ps.flush();
        return new String(os.toByteArray(), Pdf.CHARSET);
    }
}

