/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.io;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfStreamReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.io.SeekableByteBufferChannel;
import com.ionic.sdk.core.zip.Flate;
import com.ionic.sdk.error.IonicException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;

@InternalUseOnly
public final class PdfObjStmReader {
    private final Xref xrefWrapper;
    private final XrefTable xrefTableWrapper;

    PdfObjStmReader(Xref xref, XrefTable xrefTable) {
        this.xrefWrapper = xref;
        this.xrefTableWrapper = xrefTable;
    }

    public SeekableByteChannel getChannel(SeekableByteChannel channel) throws IonicException, IOException {
        int objectNumber = this.xrefWrapper.getObjStmEntry().getObjectNumber();
        Xref xref = (Xref)this.xrefTableWrapper.get(objectNumber);
        PdfObjectReader pdfObjectReader = new PdfObjectReader(channel, xref, this.xrefTableWrapper);
        PdfBodyObject pdfBodyObject = pdfObjectReader.readPartial();
        PdfStreamReader pdfStreamReader = new PdfStreamReader(pdfObjectReader);
        byte[] pdfStreamRaw = pdfStreamReader.readStream(pdfBodyObject);
        String filter = pdfBodyObject.getDictionaryValue("/Filter");
        boolean deflated = "/FlateDecode".equals(filter);
        byte[] pdfStream = deflated ? Flate.inflate(pdfStreamRaw) : pdfStreamRaw;
        return new SeekableByteBufferChannel(pdfStream);
    }
}

