/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.io;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfDictionaryReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjStmReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalUseOnly
public final class PdfObjectReader {
    private final SeekableByteChannel channel;
    private final Xref xref;
    private final XrefTable xrefTable;
    private static final int MAX_OBJ_START = 256;
    private static final Pattern OBJ_PROLOGUE = Pattern.compile("(?s)\\G(\\d+)\\s(\\d+)\\sobj\\s*");
    private static final String REGEX_REFERENCE_DIRECT = "\\d+";
    private static final String REGEX_REFERENCE_INDIRECT = "(\\d+) (\\d+) R";
    private static final Pattern OBJ_STREAM_OPEN = Pattern.compile("\\Gstream\\s{1,2}");
    private static final Pattern OBJ_STREAM_CLOSE = Pattern.compile("\\G\\s{0,2}endstream\\s{1,2}endobj\\s");

    public SeekableByteChannel getChannel() {
        return this.channel;
    }

    public PdfObjectReader(SeekableByteChannel channel, Xref xref, XrefTable xrefTable) throws IonicException, IOException {
        boolean isObjStm = xref.getObjStmEntry() != null;
        this.channel = isObjStm ? new PdfObjStmReader(xref, xrefTable).getChannel(channel) : channel;
        this.xref = xref;
        this.xrefTable = xrefTable;
    }

    public PdfBodyObject readPartial() throws IonicException, IOException {
        String prologue;
        boolean isObjectStream;
        SeekableByteChannel position = this.channel.position(this.xref.getOffset());
        SdkData.checkTrue((long)this.xref.getOffset() == position.position(), 80009);
        Scanner scanner = new Scanner((ReadableByteChannel)this.channel, Pdf.CHARSET);
        boolean bl = isObjectStream = this.xref.getObjStmEntry() != null;
        if (isObjectStream) {
            prologue = "";
        } else {
            String withinHorizon = scanner.findWithinHorizon(OBJ_PROLOGUE, 256);
            SdkData.checkTrue(withinHorizon != null, 80011);
            prologue = withinHorizon;
        }
        PdfDictionaryReader reader = new PdfDictionaryReader(scanner);
        PdfObject value = reader.read();
        int offsetStream = prologue.length() + reader.getCount();
        return new PdfBodyObject(this.xref, value, offsetStream, prologue);
    }

    public int readStreamInit(PdfBodyObject pdfBodyObject) throws IOException, IonicException {
        int offsetPdfStream = pdfBodyObject.getXref().getOffset() + pdfBodyObject.getOffsetStream();
        this.channel.position(offsetPdfStream);
        Scanner scanner = new Scanner((ReadableByteChannel)this.channel, Pdf.CHARSET);
        String streamOpen = scanner.findWithinHorizon(OBJ_STREAM_OPEN, 32);
        SdkData.checkTrue(streamOpen != null, 80011);
        int lengthToken = scanner.match().end() - scanner.match().start();
        return (int)this.channel.position(offsetPdfStream + lengthToken).position();
    }

    public int readStreamLength(String lengthStream) throws IOException, IonicException {
        Matcher matcherDirect = Pattern.compile(REGEX_REFERENCE_DIRECT).matcher(lengthStream);
        Matcher matcherIndirect = Pattern.compile(REGEX_REFERENCE_INDIRECT).matcher(lengthStream);
        if (matcherDirect.matches()) {
            return Value.toInt(lengthStream, 0);
        }
        if (matcherIndirect.matches()) {
            int objectNumber = Value.toInt(matcherIndirect.group(1), 0);
            SdkData.checkTrue(objectNumber > 0, 80011);
            Xref xrefIndirect = (Xref)this.xrefTable.get(objectNumber);
            PdfObjectReader readerIndirect = new PdfObjectReader(this.channel, xrefIndirect, this.xrefTable);
            PdfBodyObject pdfBodyObjectIndirect = readerIndirect.readPartial();
            return Value.toInt(pdfBodyObjectIndirect.getStringValue(), 0);
        }
        throw new IonicException(80011);
    }

    public void readStreamWrapup() throws IonicException {
        Scanner scanner = new Scanner((ReadableByteChannel)this.channel, Pdf.CHARSET);
        String streamClose = scanner.findWithinHorizon(OBJ_STREAM_CLOSE, 32);
        SdkData.checkTrue(streamClose != null, 80011);
    }
}

