/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.io;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfDictionaryWriter;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfStreamWriter;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

@InternalUseOnly
public class PdfObjectWriter {
    private final OutputStream outputStream;
    private final PrintStream printStream;
    private final PdfBodyObject pdfBodyObject;
    private final boolean compatibility;
    private final PdfStreamWriter streamWriter;

    public PdfObjectWriter(OutputStream outputStream, PdfBodyObject pdfBodyObject, boolean compatibility) throws UnsupportedEncodingException {
        this.outputStream = outputStream;
        this.printStream = new PrintStream(outputStream, false, Pdf.CHARSET);
        this.pdfBodyObject = pdfBodyObject;
        this.compatibility = compatibility;
        this.streamWriter = new PdfStreamWriter(outputStream, this.printStream);
    }

    public int writeBegin() throws UnsupportedEncodingException {
        Xref xref = this.pdfBodyObject.getXref();
        String objBegin = String.format("%d %d obj", xref.getObjectNumber(), xref.getGenerationNum());
        this.printStream.print(objBegin);
        this.printStream.print("\n");
        PdfDictionary pdfDictionary = this.pdfBodyObject.getDictionary();
        PdfDictionaryWriter writer = new PdfDictionaryWriter(this.printStream);
        int dictionaryWrite = writer.write(pdfDictionary, this.compatibility);
        int streamWriteBegin = this.pdfBodyObject.hasStream() ? this.streamWriter.writeBegin() : 0;
        this.printStream.flush();
        return objBegin.length() + "\n".length() + dictionaryWrite + streamWriteBegin;
    }

    public int write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        return bytes.length;
    }

    public int writeEnd() {
        int streamWriteEnd = this.pdfBodyObject.hasStream() ? this.streamWriter.writeEnd() : 0;
        this.printStream.print("endobj\n");
        this.printStream.flush();
        return streamWriteEnd + "endobj\n".length();
    }
}

