/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.io;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.io.ByteChannelWindow;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

@InternalUseOnly
public final class PdfStreamReader {
    private final PdfObjectReader pdfObjectReader;
    public static final int BLOCK_SIZE_PLAIN = 65536;

    public PdfStreamReader(PdfObjectReader pdfObjectReader) {
        this.pdfObjectReader = pdfObjectReader;
    }

    public byte[] readStream(PdfBodyObject pdfBodyObject) throws IOException, IonicException {
        int start = this.pdfObjectReader.readStreamInit(pdfBodyObject);
        int length = this.pdfObjectReader.readStreamLength(pdfBodyObject.getDictionaryValue("/Length"));
        SdkData.checkTrue(length > 0, 80011);
        int end = start + length;
        ByteChannelWindow byteChannelWindow = new ByteChannelWindow(this.pdfObjectReader.getChannel(), start, end);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        while (byteChannelWindow.available() > 0L) {
            int bytesRead = byteChannelWindow.read(buffer);
            os.write(buffer, 0, bytesRead);
        }
        this.pdfObjectReader.readStreamWrapup();
        return os.toByteArray();
    }
}

