/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.output;

import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.family.generic.output.GenericOutput;
import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectWriter;
import com.ionic.sdk.agent.cipher.file.family.pdf.output.PdfBodyOutput;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

@InternalUseOnly
public final class Pdf10BodyOutput
implements PdfBodyOutput {
    private final BufferedOutputStream targetStream;
    private final FileCryptoEncryptAttributes encryptAttributes;
    private final PdfObjectWriter writer;
    private int pdfObjectBegin;
    private final GenericOutput genericOutput;

    Pdf10BodyOutput(BufferedOutputStream targetStream, long sizeInput, KeyServices agent, FileCryptoEncryptAttributes encryptAttributes, PdfBodyObject bodyObjectPayload) throws UnsupportedEncodingException {
        this.targetStream = targetStream;
        this.encryptAttributes = encryptAttributes;
        this.writer = new PdfObjectWriter(targetStream, bodyObjectPayload, true);
        this.genericOutput = new GenericOutput(targetStream, sizeInput, agent);
    }

    @Override
    public int init() throws IOException, IonicException {
        this.pdfObjectBegin = this.writer.writeBegin();
        FileCryptoEncryptAttributes encryptAttributesWrapped = new FileCryptoEncryptAttributes("1.2");
        encryptAttributesWrapped.setKeyAttributes(this.encryptAttributes.getKeyAttributes());
        encryptAttributesWrapped.setMutableKeyAttributes(this.encryptAttributes.getMutableKeyAttributes());
        encryptAttributesWrapped.setMetadata(this.encryptAttributes.getMetadata());
        int wrappedInit = this.genericOutput.init(encryptAttributesWrapped);
        this.targetStream.flush();
        this.encryptAttributes.setKeyResponse(encryptAttributesWrapped.getKeyResponse());
        return this.pdfObjectBegin + wrappedInit;
    }

    @Override
    public int getBlockLengthPlain() {
        return this.genericOutput.getBlockLengthPlain();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, IonicException {
        return this.genericOutput.write(byteBuffer);
    }

    @Override
    public int doFinal() {
        return this.writer.writeEnd();
    }

    @Override
    public byte[] getSignature() throws IonicException {
        return this.genericOutput.getSignature();
    }

    @Override
    public int getSignatureOffset() {
        return this.pdfObjectBegin + this.genericOutput.getSignatureOffset();
    }

    @Override
    public int getOutputLength() {
        return this.genericOutput.getOutputLength();
    }

    @Override
    public ByteBuffer getPlainText() {
        return this.genericOutput.getPlainText();
    }
}

