/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.output;

import com.ionic.sdk.agent.cipher.file.cover.FileCryptoCoverPageServicesInterface;
import com.ionic.sdk.agent.cipher.file.data.CipherFamily;
import com.ionic.sdk.agent.cipher.file.data.FileCryptoEncryptAttributes;
import com.ionic.sdk.agent.cipher.file.data.FileType;
import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDocument;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfString;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectWriter;
import com.ionic.sdk.agent.cipher.file.family.pdf.output.Pdf10BodyOutput;
import com.ionic.sdk.agent.cipher.file.family.pdf.output.PdfBodyOutput;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTableWriter;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.io.SeekableByteBufferChannel;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

@InternalUseOnly
public final class PdfOutput {
    private final BufferedOutputStream targetStream;
    private final long sizeInput;
    private final KeyServices agent;
    private final FileCryptoCoverPageServicesInterface coverPageServices;
    private PdfBodyOutput bodyOutput;
    private PdfDocument documentCoverPage;
    private final Collection<Xref> xrefsIonic;
    private Xref referenceInfoIonic;
    private int sizeDocumentWrite;
    private int signatureOffset;
    private int offsetPayloadIonic;
    private PdfBodyObject bodyObjectPayload;

    public PdfOutput(OutputStream outputStream, long sizeInput, KeyServices agent, FileCryptoCoverPageServicesInterface coverPageServices) {
        this.targetStream = new BufferedOutputStream(outputStream);
        this.sizeInput = sizeInput;
        this.agent = agent;
        this.coverPageServices = coverPageServices;
        this.xrefsIonic = new ArrayList<Xref>();
        this.referenceInfoIonic = null;
        this.sizeDocumentWrite = 0;
        this.signatureOffset = 0;
        this.offsetPayloadIonic = 0;
    }

    public void init(FileCryptoEncryptAttributes encryptAttributes) throws IonicException, IOException {
        PdfDictionary dictionaryInfo;
        int objNumPayloadIonic;
        PdfDictionary trailerDictionary;
        String version = Value.defaultOnEmpty(encryptAttributes.getVersion(), "1.0");
        encryptAttributes.setFamily(CipherFamily.FAMILY_PDF);
        encryptAttributes.setVersion(version);
        SdkData.checkTrue(!Value.isEmpty(version), 80004);
        byte[] coverPage = this.coverPageServices.getCoverPage(FileType.FILETYPE_PDF);
        this.targetStream.write(coverPage);
        this.sizeDocumentWrite += coverPage.length;
        SeekableByteBufferChannel channelCoverPage = new SeekableByteBufferChannel(coverPage);
        this.documentCoverPage = new PdfDocument(channelCoverPage, coverPage.length);
        this.documentCoverPage.initialize();
        XrefTable xrefTable = this.documentCoverPage.getXrefTable();
        Collection xrefsTable = xrefTable.values();
        if (!xrefsTable.isEmpty()) {
            this.xrefsIonic.add((Xref)xrefsTable.iterator().next());
        }
        SdkData.checkTrue((trailerDictionary = xrefTable.getTrailerDictionary()) != null, 80011);
        int size = Value.toInt(trailerDictionary.getStringValue("/Size"), 0);
        String referenceInfo = trailerDictionary.getStringValue("/Info");
        int referenceId = Xref.getIdentifier(referenceInfo);
        Xref xrefInfo = this.documentCoverPage.getXrefIndirect(referenceId);
        int objNumInfoIonic = xrefInfo == null ? size : xrefInfo.getObjectNumber();
        int genNumInfoIonic = xrefInfo == null ? 0 : xrefInfo.getGenerationNum() + 1;
        Xref xrefInfoIonic = new Xref(objNumInfoIonic, coverPage.length, genNumInfoIonic, "n", null);
        this.xrefsIonic.add(xrefInfoIonic);
        this.referenceInfoIonic = xrefInfo == null ? xrefInfoIonic : xrefInfo;
        int n = objNumPayloadIonic = xrefInfo == null ? size + 1 : size;
        if (xrefInfo == null) {
            dictionaryInfo = new PdfDictionary();
            dictionaryInfo.put("/Info", new PdfString(Value.join(" ", objNumInfoIonic, xrefInfoIonic.getGenerationNum(), "R")));
            dictionaryInfo.put("/Size", new PdfString(Integer.toString(objNumPayloadIonic + 1)));
        } else {
            PdfObjectReader readerInfo = this.documentCoverPage.getPdfObjectReader(xrefInfo.getObjectNumber());
            PdfBodyObject bodyInfo = readerInfo.readPartial();
            dictionaryInfo = bodyInfo.getDictionary();
        }
        SdkData.checkTrue(dictionaryInfo != null, 80011);
        dictionaryInfo.put("/IonicPayload", new PdfString(Value.join(" ", objNumPayloadIonic, 0, "R")));
        PdfBodyObject bodyObjectInfo = new PdfBodyObject(xrefInfoIonic, dictionaryInfo, 0, null);
        ByteArrayOutputStream osInfo = new ByteArrayOutputStream();
        PdfObjectWriter writerInfo = new PdfObjectWriter(osInfo, bodyObjectInfo, false);
        writerInfo.writeBegin();
        writerInfo.writeEnd();
        this.targetStream.write(osInfo.toByteArray());
        this.sizeDocumentWrite += osInfo.size();
        this.offsetPayloadIonic = coverPage.length + osInfo.size();
        Xref xrefPayloadIonic = new Xref(objNumPayloadIonic, this.offsetPayloadIonic, 0, "n", null);
        this.xrefsIonic.add(xrefPayloadIonic);
        PdfDictionary dictionaryPayload = new PdfDictionary();
        dictionaryPayload.put("/Length", new PdfString(String.format("%010d", 0)));
        this.bodyObjectPayload = new PdfBodyObject(xrefPayloadIonic, dictionaryPayload, -1, null);
        if (!"1.0".equals(version)) {
            throw new IonicException(80012);
        }
        this.bodyOutput = new Pdf10BodyOutput(this.targetStream, this.sizeInput, this.agent, encryptAttributes, this.bodyObjectPayload);
        this.signatureOffset = this.sizeDocumentWrite;
        this.sizeDocumentWrite += this.bodyOutput.init();
        this.signatureOffset += this.bodyOutput.getSignatureOffset();
    }

    public int getBlockLengthPlain() {
        return this.bodyOutput.getBlockLengthPlain();
    }

    public ByteBuffer getPlainText() {
        return this.bodyOutput.getPlainText();
    }

    public void write(ByteBuffer byteBuffer) throws IOException, IonicException {
        this.sizeDocumentWrite += this.bodyOutput.write(byteBuffer);
    }

    public void doFinal() throws IOException, IonicException {
        this.sizeDocumentWrite += this.bodyOutput.doFinal();
        ByteArrayOutputStream osEpiloguePdf = new ByteArrayOutputStream();
        osEpiloguePdf.write(Transcoder.utf8().decode("xref\n"));
        XrefTableWriter xrefTableWriter = new XrefTableWriter(osEpiloguePdf);
        for (Xref xref : this.xrefsIonic) {
            XrefTable xrefTable = new XrefTable(0);
            xrefTable.put(xref.getObjectNumber(), xref);
            xrefTableWriter.write(xref.getObjectNumber(), xrefTable);
        }
        XrefTable xrefTable = this.documentCoverPage.getXrefTable();
        PdfDictionary trailerDictionary = xrefTable.getTrailerDictionary();
        PdfObject encrypt = (PdfObject)trailerDictionary.remove("/Encrypt");
        int sizeOld = Value.toInt(trailerDictionary.getStringValue("/Size"), 0);
        int size = encrypt == null ? sizeOld : sizeOld - 1;
        SdkData.checkTrue(this.referenceInfoIonic != null, 80004);
        trailerDictionary.put("/Info", new PdfString(this.referenceInfoIonic.toReference()));
        trailerDictionary.put("/Prev", new PdfString(Integer.toString(xrefTable.getOffset())));
        trailerDictionary.put("/Size", new PdfString(Integer.toString(size + 1)));
        osEpiloguePdf.write(Transcoder.utf8().decode("trailer\n"));
        xrefTableWriter.write(trailerDictionary);
        PrintStream printStream = new PrintStream((OutputStream)osEpiloguePdf, false, Pdf.CHARSET);
        printStream.print("startxref\n");
        printStream.print(this.sizeDocumentWrite);
        printStream.print("\n");
        printStream.print("%%EOF\n");
        this.targetStream.write(osEpiloguePdf.toByteArray());
        this.targetStream.flush();
    }

    public byte[] getSignature() throws IonicException {
        return this.bodyOutput.getSignature();
    }

    public int getSignatureOffset() {
        return this.signatureOffset;
    }

    public byte[] getIonicPayloadPrologue() throws IonicException {
        int sizeCipherText = this.bodyOutput.getOutputLength();
        PdfDictionary dictionary = this.bodyObjectPayload.getDictionary();
        SdkData.checkTrue(dictionary != null, 80011);
        dictionary.put("/Length", new PdfString(String.format("%010d", sizeCipherText)));
        PdfBodyObject bodyObject = new PdfBodyObject(this.bodyObjectPayload.getXref(), this.bodyObjectPayload.getDictionary(), this.bodyObjectPayload.getOffsetStream(), this.bodyObjectPayload.getPrologue());
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PdfObjectWriter writer = new PdfObjectWriter(os, bodyObject, true);
            writer.writeBegin();
            return os.toByteArray();
        }
        catch (UnsupportedEncodingException e) {
            throw new IonicException(80023, (Throwable)e);
        }
    }

    public int getOffsetPayloadIonic() {
        return this.offsetPayloadIonic;
    }
}

