/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.stream;

import com.ionic.sdk.agent.cipher.file.family.pdf.body.PdfBodyObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfObject;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfObjectReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfStreamReader;
import com.ionic.sdk.agent.cipher.file.family.pdf.stream.ObjStmEntry;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.io.SeekableByteBufferChannel;
import com.ionic.sdk.core.value.BytesReader;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.core.zip.Flate;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;

@InternalUseOnly
public final class StreamXrefTableReader {
    private final PdfBodyObject pdfBodyObject;
    private static final String FORMAT_XREF_TRACE = "objnum=%d field1=%d, field2=%d, field3=%d";

    public StreamXrefTableReader(PdfBodyObject pdfBodyObject) {
        this.pdfBodyObject = pdfBodyObject;
    }

    public XrefTable read(int offset, SeekableByteChannel channel, byte[] bytes) throws IonicException, IOException {
        int i;
        int count;
        int start;
        PdfDictionary dictionary = this.pdfBodyObject.getDictionary();
        SdkData.checkTrue(dictionary != null, 80011);
        ArrayList<Integer> objnums = new ArrayList<Integer>();
        List<PdfObject> index = dictionary.getArrayValue("/Index");
        if (index != null) {
            SdkData.checkTrue(index.size() % 2 == 0, 80011);
            Iterator<PdfObject> it = index.iterator();
            while (it.hasNext()) {
                start = Value.toInt(it.next().toString(), 0);
                count = Value.toInt(it.next().toString(), 0);
                for (i = 0; i < count; ++i) {
                    objnums.add(start + i);
                }
            }
        } else {
            String size = dictionary.getStringValue("/Size");
            start = 0;
            count = Value.toInt(size, 0);
            for (i = 0; i < count; ++i) {
                objnums.add(0 + i);
            }
        }
        int countFieldsValueW = 3;
        List<PdfObject> array = dictionary.getArrayValue("/W");
        SdkData.checkTrue(array != null, 80011);
        SdkData.checkTrue(3 == array.size(), 80011);
        Iterator<PdfObject> it = array.iterator();
        int field1Width = Value.toInt(it.next().toString(), 0);
        int field2Width = Value.toInt(it.next().toString(), 0);
        int field3Width = Value.toInt(it.next().toString(), 0);
        PdfDictionary decodeParms = (PdfDictionary)dictionary.get("/DecodeParms");
        boolean isDecodeParms = decodeParms != null;
        int columnsFields = field1Width + field2Width + field3Width;
        int columnsRow = columnsFields + (isDecodeParms ? 1 : 0);
        int rows = bytes.length / columnsRow;
        SdkData.checkTrue(bytes.length == rows * columnsRow, 80011);
        SdkData.checkTrue(objnums.size() == rows, 80011);
        int columnsRecord = columnsRow + (isDecodeParms ? 0 : 1);
        XrefTable xrefTable = new XrefTable(offset);
        byte[] recordLast = new byte[columnsRecord];
        for (int cursor = 0; cursor < bytes.length; cursor += columnsRow) {
            byte[] record = new byte[columnsRecord];
            System.arraycopy(bytes, cursor, record, isDecodeParms ? 0 : 1, columnsRow);
            this.applyCompressionTransform(record, recordLast);
            Integer objnum = (Integer)objnums.iterator().next();
            objnums.remove(objnum);
            this.processXref(record, objnum, xrefTable, field1Width, field2Width, field3Width);
            recordLast = record;
        }
        xrefTable.setTrailerDictionary(dictionary);
        this.resolveObjStmOffsets(channel, xrefTable);
        return xrefTable;
    }

    private void applyCompressionTransform(byte[] record, byte[] recordLast) throws IonicException {
        byte predictor = record[0];
        switch (predictor) {
            case 0: {
                break;
            }
            case 1: {
                for (int i = 1; i < record.length; ++i) {
                    int n = i;
                    record[n] = (byte)(record[n] + record[i - 1]);
                }
                break;
            }
            case 2: {
                for (int i = 1; i < record.length; ++i) {
                    int n = i;
                    record[n] = (byte)(record[n] + recordLast[i]);
                }
                break;
            }
            default: {
                throw new IonicException(80011, (Throwable)new IllegalArgumentException(String.format("XREF STREAM, predictor=%d", predictor)));
            }
        }
    }

    private void processXref(byte[] record, int objnum, XrefTable xrefTable, int field1Width, int field2Width, int field3Width) throws IonicException {
        boolean offsetField1 = true;
        int offsetField2 = 1 + field1Width;
        int offsetField3 = offsetField2 + field2Width;
        int field1 = BytesReader.readInt(record, 1, 1 + field1Width);
        int field2 = BytesReader.readInt(record, offsetField2, offsetField2 + field2Width);
        int field3 = BytesReader.readInt(record, offsetField3, offsetField3 + field3Width);
        String trace = String.format(FORMAT_XREF_TRACE, objnum, field1, field2, field3);
        switch (field1) {
            case 0: {
                break;
            }
            case 1: {
                xrefTable.put(objnum, new Xref(objnum, field2, 0, "n", null));
                break;
            }
            case 2: {
                xrefTable.put(objnum, new Xref(objnum, 0, 0, "n", new ObjStmEntry(field2, field3)));
                break;
            }
            default: {
                throw new IonicException(80011, (Throwable)new IllegalArgumentException(trace));
            }
        }
    }

    private void resolveObjStmOffsets(SeekableByteChannel channel, XrefTable xrefTable) throws IonicException, IOException {
        TreeSet<Integer> objStms = new TreeSet<Integer>();
        for (Xref xref : xrefTable.values()) {
            ObjStmEntry objStmEntry = xref.getObjStmEntry();
            if (objStmEntry == null) continue;
            objStms.add(objStmEntry.getObjectNumber());
        }
        for (Integer objStmIt : objStms) {
            Xref xref = (Xref)xrefTable.get(objStmIt);
            SdkData.checkTrue(xref != null, 80011);
            PdfObjectReader objectReaderIt = new PdfObjectReader(channel, xref, null);
            PdfBodyObject objectIt = objectReaderIt.readPartial();
            int firstIt = Value.toInt(objectIt.getDictionaryValue("/First"), 0);
            PdfStreamReader streamReaderIt = new PdfStreamReader(objectReaderIt);
            byte[] pdfStreamRawIt = streamReaderIt.readStream(objectIt);
            boolean deflatedIt = "/FlateDecode".equals(objectIt.getDictionaryValue("/Filter"));
            byte[] pdfStreamIt = deflatedIt ? Flate.inflate(pdfStreamRawIt) : pdfStreamRawIt;
            SeekableByteBufferChannel channelIt = new SeekableByteBufferChannel(pdfStreamIt);
            Scanner scannerIt = new Scanner((ReadableByteChannel)channelIt, Pdf.CHARSET);
            int horizonEntry = 32;
            while (scannerIt.findWithinHorizon(Pdf.Regex.OBJSTM_ENTRY, 32) != null) {
                int objnumIt = Value.toInt(scannerIt.match().group(1), 0);
                int offsetIt = firstIt + Value.toInt(scannerIt.match().group(2), 0);
                Xref xrefIt = (Xref)xrefTable.get(objnumIt);
                SdkData.checkTrue(xrefIt != null, 80011);
                ObjStmEntry objStmEntryIt = xrefIt.getObjStmEntry();
                SdkData.checkTrue(objStmEntryIt != null, 80011);
                SdkData.checkTrue(objStmEntryIt.getObjectNumber() == objStmIt.intValue(), 80011);
                xrefIt.setOffset(offsetIt);
            }
        }
    }
}

