/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.xref;

import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.stream.ObjStmEntry;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalUseOnly
public final class Xref {
    private final int objectNumber;
    private int offset;
    private final int generationNum;
    private final String inUse;
    private final ObjStmEntry objStmEntry;
    private static final String REGEX_REFERENCE_INDIRECT = "(\\d+) (\\d+) R";

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getGenerationNum() {
        return this.generationNum;
    }

    public String getInUse() {
        return this.inUse;
    }

    public boolean isInUse() {
        return "n".equals(this.inUse);
    }

    public ObjStmEntry getObjStmEntry() {
        return this.objStmEntry;
    }

    public Xref(String entry, int objectNumber) {
        this.objectNumber = objectNumber;
        Matcher matcher = Pdf.Regex.XREF_ENTRY.matcher(entry);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(entry);
        }
        int group = 0;
        this.offset = Value.toInt(matcher.group(++group), 0);
        this.generationNum = Value.toInt(matcher.group(++group), 0);
        this.inUse = matcher.group(++group);
        this.objStmEntry = null;
    }

    public Xref(int objectNumber, int offset, int generationNum, String inUse, ObjStmEntry objStmEntry) {
        this.objectNumber = objectNumber;
        this.offset = offset;
        this.generationNum = generationNum;
        this.inUse = inUse;
        this.objStmEntry = objStmEntry;
    }

    public String toReference() {
        return Value.join(" ", this.objectNumber, this.generationNum, "R");
    }

    public static int getIdentifier(String reference) {
        String input = reference == null ? "" : reference;
        Matcher matcherIndirect = Pattern.compile(REGEX_REFERENCE_INDIRECT).matcher(input);
        String token = matcherIndirect.matches() ? matcherIndirect.group(1) : null;
        return token == null ? Integer.MIN_VALUE : Value.toInt(token, Integer.MIN_VALUE);
    }
}

